/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.VertxException;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.auth.mongo.HashAlgorithm;
import io.vertx.ext.auth.mongo.HashSaltStyle;
import io.vertx.ext.auth.mongo.HashStrategy;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

@Deprecated
public class DefaultHashStrategy
implements HashStrategy {
    private static final int WORK_FACTOR = 10000;
    private HashSaltStyle saltStyle;
    private String externalSalt;
    private HashAlgorithm algorithm;
    private SecretKeyFactory skf;
    private MessageDigest md;

    public DefaultHashStrategy() {
        this.saltStyle = HashSaltStyle.COLUMN;
    }

    public DefaultHashStrategy(String externalSalt) {
        this.saltStyle = HashSaltStyle.EXTERNAL;
        this.externalSalt = externalSalt;
    }

    private synchronized void initMessageDigest() {
        try {
            if (this.md == null) {
                this.md = MessageDigest.getInstance("SHA-512");
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("PBKDF2 is not available", nsae);
        }
    }

    private synchronized void initKeyFactory() {
        try {
            if (this.skf == null) {
                this.skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("PBKDF2 is not available", nsae);
        }
    }

    @Override
    public String computeHash(String password, User user) {
        switch (this.saltStyle) {
            case NO_SALT: {
                return password;
            }
            case COLUMN: 
            case EXTERNAL: {
                String salt = this.getSalt(user);
                return this.computeHash(password, salt);
            }
        }
        throw new UnsupportedOperationException("Not existing, saltstyle " + (Object)((Object)this.saltStyle));
    }

    @Override
    public String getStoredPwd(User user) {
        String fieldPassword = user.principal().getString("__field-password__");
        return fieldPassword != null ? user.principal().getString(fieldPassword) : null;
    }

    @Override
    public String getSalt(User user) {
        switch (this.saltStyle) {
            case NO_SALT: {
                return null;
            }
            case COLUMN: {
                String fieldSalt = user.principal().getString("__field-salt__");
                return fieldSalt != null ? user.principal().getString(fieldSalt) : null;
            }
            case EXTERNAL: {
                return this.externalSalt;
            }
        }
        throw new UnsupportedOperationException("Not existing, saltstyle " + (Object)((Object)this.saltStyle));
    }

    @Override
    public void setSaltStyle(HashSaltStyle saltStyle) {
        this.saltStyle = saltStyle;
    }

    @Override
    public HashSaltStyle getSaltStyle() {
        return this.saltStyle;
    }

    @Override
    public void setAlgorithm(HashAlgorithm algorithm) {
        switch (algorithm) {
            case SHA512: {
                this.initMessageDigest();
                this.algorithm = algorithm;
                break;
            }
            case PBKDF2: {
                this.initKeyFactory();
                this.algorithm = algorithm;
                break;
            }
            default: {
                throw new VertxException("Algorithm " + (Object)((Object)algorithm) + " not supported");
            }
        }
    }

    private String computeHash(String password, String salt) {
        if (this.algorithm == null) {
            this.setAlgorithm(HashAlgorithm.SHA512);
        }
        try {
            switch (this.algorithm) {
                case SHA512: {
                    String concat = (salt == null ? "" : salt) + password;
                    return Codec.base16Encode((byte[])this.md.digest(concat.getBytes(StandardCharsets.UTF_8)));
                }
                case PBKDF2: {
                    PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt == null ? new byte[]{} : salt.getBytes(StandardCharsets.UTF_8), 10000, 512);
                    return Codec.base16Encode((byte[])this.skf.generateSecret(spec).getEncoded()).toUpperCase();
                }
            }
            throw new VertxException("Can't compute hash for algorithm: " + (Object)((Object)this.algorithm));
        }
        catch (InvalidKeySpecException e) {
            throw new VertxException((Throwable)e);
        }
    }

    public static String generateSalt() {
        SecureRandom r = new SecureRandom();
        byte[] salt = new byte[32];
        ((Random)r).nextBytes(salt);
        return Codec.base16Encode((byte[])salt).toUpperCase();
    }

    @Override
    public void setExternalSalt(String externalSalt) {
        this.externalSalt = externalSalt;
    }
}

