/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.mongo.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.impl.UserImpl;
import io.vertx.ext.auth.mongo.HashStrategy;
import io.vertx.ext.auth.mongo.MongoAuthentication;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.mongo.MongoClient;
import java.util.List;
import java.util.Map;

public class MongoAuthenticationImpl
implements MongoAuthentication {
    private static final Logger log = LoggerFactory.getLogger(MongoAuthenticationImpl.class);
    private final HashingStrategy strategy = HashingStrategy.load();
    private final MongoClient mongoClient;
    private final MongoAuthenticationOptions options;
    private HashStrategy legacyStrategy;
    private String hashField;

    public MongoAuthenticationImpl(MongoClient mongoClient, MongoAuthenticationOptions options) {
        this.mongoClient = mongoClient;
        this.options = options;
    }

    public MongoAuthenticationImpl(MongoClient mongoClient, HashStrategy legacyStrategy, String hashField, MongoAuthenticationOptions options) {
        this.mongoClient = mongoClient;
        this.options = options;
        this.legacyStrategy = legacyStrategy;
        this.hashField = hashField;
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate((Credentials)new UsernamePasswordCredentials(credentials.getString(this.options.getUsernameCredentialField()), credentials.getString(this.options.getPasswordCredentialField())), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            if (credentials == null) {
                resultHandler.handle((Object)Future.failedFuture((String)"Credentials must be set for authentication."));
                return;
            }
            UsernamePasswordCredentials authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
            AuthToken token = new AuthToken(authInfo.getUsername(), authInfo.getPassword());
            JsonObject query = this.createQuery(authInfo.getUsername());
            this.mongoClient.find(this.options.getCollectionName(), query, res -> {
                try {
                    if (res.succeeded()) {
                        User user = this.handleSelection((AsyncResult<List<JsonObject>>)res, token);
                        resultHandler.handle((Object)Future.succeededFuture((Object)user));
                    } else {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    }
                }
                catch (Exception e) {
                    log.warn((Object)e);
                    resultHandler.handle((Object)Future.failedFuture((Throwable)e));
                }
            });
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    protected JsonObject createQuery(String username) {
        return new JsonObject().put(this.options.getUsernameField(), (Object)username);
    }

    private User handleSelection(AsyncResult<List<JsonObject>> resultList, AuthToken authToken) throws Exception {
        switch (((List)resultList.result()).size()) {
            case 0: {
                String message = "No account found for user [" + authToken.username + "]";
                throw new Exception(message);
            }
            case 1: {
                JsonObject json = (JsonObject)((List)resultList.result()).get(0);
                User user = this.createUser(json);
                if (this.examinePassword(user, json.getString(this.options.getPasswordField()), authToken.password)) {
                    return user;
                }
                String message = "Invalid username/password [" + authToken.username + "]";
                throw new Exception(message);
            }
        }
        String message = "More than one user row found for user [" + authToken.username + "( " + ((List)resultList.result()).size() + " )]. Usernames must be unique.";
        throw new Exception(message);
    }

    private User createUser(JsonObject json) {
        UserImpl user = new UserImpl(json);
        if (this.legacyStrategy != null) {
            json.put("__field-salt__", (Object)this.hashField);
            json.put("__field-password__", (Object)this.options.getPasswordField());
        }
        return user;
    }

    private boolean examinePassword(User user, String hash, String password) {
        if (hash.charAt(0) != '$') {
            if (this.legacyStrategy == null) {
                throw new IllegalStateException("Mongo Authentication cannot handle legacy hashes without a HashStrategy");
            }
            String givenPassword = this.legacyStrategy.computeHash(password, user);
            return hash.equals(givenPassword);
        }
        return this.strategy.verify(hash, password);
    }

    @Override
    public String hash(String id, Map<String, String> params, String salt, String password) {
        return this.strategy.hash(id, params, salt, password);
    }

    static class AuthToken {
        final String username;
        final String password;

        AuthToken(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

