/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Coordinate;
import io.vertx.ext.consul.CoordinateListConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class CoordinateList {
    private long index;
    private List<Coordinate> list;

    public CoordinateList() {
    }

    public CoordinateList(CoordinateList other) {
        this.index = other.index;
        this.list = other.list;
    }

    public CoordinateList(JsonObject json) {
        CoordinateListConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        CoordinateListConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public long getIndex() {
        return this.index;
    }

    public List<Coordinate> getList() {
        return this.list;
    }

    public CoordinateList setIndex(long index) {
        this.index = index;
        return this;
    }

    public CoordinateList setList(List<Coordinate> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateList that = (CoordinateList)o;
        if (this.index != that.index) {
            return false;
        }
        return this.list != null ? this.sorted().equals(that.sorted()) : that.list == null;
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.list != null ? this.sorted().hashCode() : 0);
        return result;
    }

    private List<Coordinate> sorted() {
        ArrayList<Coordinate> sorted = null;
        if (this.list != null) {
            sorted = new ArrayList<Coordinate>(this.list);
            sorted.sort(Comparator.comparing(Coordinate::getNode));
        }
        return sorted;
    }
}

