/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public final class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    private static final Class<?>[] ORDERED_PRIMITIVE_TYPES;

    private ReflectionUtil() {
    }

    public static <T extends AccessibleObject> T accessible(T obj) {
        if (obj == null) {
            return null;
        }
        obj.setAccessible(true);
        return obj;
    }

    public static Class<?>[] getTypes(Object ... vals) {
        Class[] types = new Class[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            types[i] = vals[i] != null ? vals[i].getClass() : null;
        }
        return types;
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray, boolean autoboxing) {
        if (classArray.length != toClassArray.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (ReflectionUtil.isAssignable(classArray[i], toClassArray[i], autoboxing)) continue;
            return false;
        }
        return true;
    }

    public static <T> Constructor<T> getMatchingConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        try {
            Constructor<T> ctor = cls.getConstructor(parameterTypes);
            return ctor;
        }
        catch (NoSuchMethodException ctor) {
            Constructor<?>[] ctors;
            Constructor<?> result = null;
            for (Constructor<?> ctor2 : ctors = cls.getConstructors()) {
                if (!ReflectionUtil.isAssignable(parameterTypes, ctor2.getParameterTypes(), true) || result != null && ReflectionUtil.compareParameterTypes(ctor2.getParameterTypes(), result.getParameterTypes(), parameterTypes) >= 0) continue;
                result = ctor2;
            }
            return result;
        }
    }

    static int compareParameterTypes(Class<?>[] left, Class<?>[] right, Class<?>[] actual) {
        float rightCost;
        float leftCost = ReflectionUtil.getTotalTransformationCost(actual, left);
        return leftCost < (rightCost = ReflectionUtil.getTotalTransformationCost(actual, right)) ? -1 : (rightCost < leftCost ? 1 : 0);
    }

    private static float getTotalTransformationCost(Class<?>[] srcArgs, Class<?>[] destArgs) {
        float totalCost = 0.0f;
        for (int i = 0; i < srcArgs.length; ++i) {
            Class<?> srcClass = srcArgs[i];
            Class<?> destClass = destArgs[i];
            totalCost += ReflectionUtil.getObjectTransformationCost(srcClass, destClass);
        }
        return totalCost;
    }

    private static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
        if (destClass.isPrimitive()) {
            return ReflectionUtil.getPrimitivePromotionCost(srcClass, destClass);
        }
        float cost = 0.0f;
        while (srcClass != null && !destClass.equals(srcClass)) {
            if (destClass.isInterface() && ReflectionUtil.isAssignable(srcClass, destClass, true)) {
                cost += 0.25f;
                break;
            }
            cost += 1.0f;
            srcClass = srcClass.getSuperclass();
        }
        if (srcClass == null) {
            cost += 1.5f;
        }
        return cost;
    }

    private static float getPrimitivePromotionCost(Class<?> srcClass, Class<?> destClass) {
        float cost = 0.0f;
        Class<?> cls = srcClass;
        if (!cls.isPrimitive()) {
            cost += 0.1f;
            cls = ReflectionUtil.wrapperToPrimitive(cls);
        }
        for (int i = 0; cls != destClass && i < ORDERED_PRIMITIVE_TYPES.length; ++i) {
            if (cls != ORDERED_PRIMITIVE_TYPES[i]) continue;
            cost += 0.1f;
            if (i >= ORDERED_PRIMITIVE_TYPES.length - 1) continue;
            cls = ORDERED_PRIMITIVE_TYPES[i + 1];
        }
        return cost;
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (autoboxing) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ReflectionUtil.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = ReflectionUtil.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static Type getGenericParameterType(Class<?> cls, Class<?> genericSuper, int paramIndex) {
        if (!genericSuper.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Class " + cls.getName() + " does not implement or extend " + genericSuper.getName());
        }
        Type res = ReflectionUtil.getGenericParameterType0(cls, genericSuper, paramIndex);
        return !(res instanceof TypeVariable) ? res : null;
    }

    private static Type getGenericParameterType0(Class<?> cls, Class<?> genericSuper, int paramIndex) {
        if (!genericSuper.isAssignableFrom(cls)) {
            return null;
        }
        if (genericSuper.isInterface()) {
            for (Type type : cls.getGenericInterfaces()) {
                Class<?> clazz = ReflectionUtil.getClass(type);
                if (!genericSuper.isAssignableFrom(clazz)) continue;
                if (genericSuper.equals(clazz)) {
                    return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[paramIndex] : null;
                }
                for (Class<?> iface : cls.getInterfaces()) {
                    Type res = ReflectionUtil.getGenericParameterType0(iface, genericSuper, paramIndex);
                    if (res == null) continue;
                    return res;
                }
            }
            return null;
        }
        Type type = cls.getGenericSuperclass();
        assert (genericSuper.isAssignableFrom(ReflectionUtil.getClass(type)));
        if (genericSuper.equals(ReflectionUtil.getClass(type))) {
            return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[paramIndex] : null;
        }
        return ReflectionUtil.getGenericParameterType0(cls.getSuperclass(), genericSuper, paramIndex);
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance((Class)((GenericArrayType)type).getGenericComponentType(), 0).getClass();
        }
        return null;
    }

    public static Class<?>[] getParameterTypes(Member m) {
        if (m instanceof Method) {
            return ((Method)m).getParameterTypes();
        }
        if (m instanceof Constructor) {
            return ((Constructor)m).getParameterTypes();
        }
        throw new IllegalArgumentException("Not an executable: " + m);
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        wrapperPrimitiveMap = new HashMap();
        for (Class<?> primitiveClass : primitiveWrapperMap.keySet()) {
            Class<?> wrapperClass;
            if (primitiveClass.equals(wrapperClass = primitiveWrapperMap.get(primitiveClass))) continue;
            wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
        ORDERED_PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    }
}

