/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.concurrent.util.SingleConsumerNonblockingProducerDelayQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class ScheduledSingleThreadExecutor
extends AbstractExecutorService
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private volatile boolean removeOnCancel = false;
    private static final AtomicInteger nameSuffixSequence = new AtomicInteger();
    private final Thread worker;
    private final SingleConsumerNonblockingProducerDelayQueue<RunnableScheduledFuture<?>> workQueue;
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int STOP = 1;
    private static final int TERMINATED = 2;
    private volatile int state;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final AtomicLong sequencer = new AtomicLong();

    public ScheduledSingleThreadExecutor(ThreadFactory threadFactory) {
        this.worker = threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                ScheduledSingleThreadExecutor.this.work();
            }
        });
        this.workQueue = new SingleConsumerNonblockingProducerDelayQueue();
        this.worker.start();
    }

    public ScheduledSingleThreadExecutor() {
        this(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "single-threaded-scheduled-executor-" + nameSuffixSequence.incrementAndGet());
            }
        });
    }

    private void work() {
        block9: {
            try {
                RunnableScheduledFuture task;
                while (this.state == 0) {
                    try {
                        task = (RunnableScheduledFuture)this.workQueue.take();
                        task.run();
                    }
                    catch (InterruptedException e) {
                        if (this.state == 0) continue;
                        this.state = 1;
                        break;
                    }
                }
                if (this.state != 1) break block9;
                this.onShutdown();
                while (this.state < 1 && !this.workQueue.isEmpty()) {
                    try {
                        task = (RunnableScheduledFuture)this.workQueue.take();
                        task.run();
                    }
                    catch (InterruptedException e) {
                        if (this.state == 0) continue;
                        this.state = 1;
                        break;
                    }
                }
            }
            finally {
                this.state = 2;
            }
        }
    }

    final long now() {
        return System.nanoTime();
    }

    final boolean isRunningOrShutdown(boolean shutdownOK) {
        int rs = this.state;
        return rs == 0 || rs == 1 && shutdownOK;
    }

    boolean canRunInCurrentRunState(boolean periodic) {
        return this.isRunningOrShutdown(periodic ? this.continueExistingPeriodicTasksAfterShutdown : this.executeExistingDelayedTasksAfterShutdown);
    }

    private void delayedExecute(RunnableScheduledFuture<?> task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            this.workQueue.add(task);
        }
    }

    protected void reject(Runnable command) {
        throw new RejectedExecutionException("Task " + command + " rejected from " + this);
    }

    void reExecutePeriodic(RunnableScheduledFuture<?> task) {
        if (this.canRunInCurrentRunState(true)) {
            this.workQueue.add(task);
            if (!this.canRunInCurrentRunState(true) && this.workQueue.remove(task)) {
                task.cancel(false);
            }
        }
    }

    private void onShutdown() {
        SingleConsumerNonblockingProducerDelayQueue<RunnableScheduledFuture<?>> q = this.workQueue;
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            for (Object e : q.toArray()) {
                if (!(e instanceof RunnableScheduledFuture)) continue;
                ((RunnableScheduledFuture)e).cancel(false);
            }
            q.clear();
        } else {
            for (Object e : q) {
                RunnableScheduledFuture t;
                if (!(e instanceof RunnableScheduledFuture) || !(!(t = (RunnableScheduledFuture)e).isPeriodic() ? !keepDelayed : !keepPeriodic) && !t.isCancelled() || !q.remove(t)) continue;
                t.cancel(false);
            }
        }
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return task;
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return task;
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    long triggerTime(long delay) {
        return this.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Delayed head = (Delayed)this.workQueue.peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(command, null, this.triggerTime(delay, unit)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<V> t = this.decorateTask(callable, new ScheduledFutureTask<V>(callable, this.triggerTime(delay, unit)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> sft = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toNanos(period));
        RunnableScheduledFuture<Object> t = this.decorateTask(command, sft);
        sft.outerTask = t;
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> sft = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toNanos(-delay));
        RunnableScheduledFuture<Object> t = this.decorateTask(command, sft);
        sft.outerTask = t;
        this.delayedExecute(t);
        return t;
    }

    @Override
    public void execute(Runnable command) {
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void setRemoveOnCancelPolicy(boolean value) {
        this.removeOnCancel = value;
    }

    public boolean getRemoveOnCancelPolicy() {
        return this.removeOnCancel;
    }

    @Override
    public void shutdown() {
        this.mainLock.lock();
        try {
            if (this.state < 1) {
                this.state = 1;
            }
        }
        finally {
            this.mainLock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.mainLock.lock();
        try {
            if (this.state < 1) {
                this.state = 1;
            }
            this.worker.interrupt();
            ArrayList<Runnable> list = new ArrayList<Runnable>();
            this.workQueue.drainTo(list);
            ArrayList<Runnable> arrayList = list;
            return arrayList;
        }
        finally {
            this.mainLock.unlock();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        long millis = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        this.worker.join(millis, (int)(nanos - millis));
        return !this.worker.isAlive();
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 1;
    }

    @Override
    public boolean isTerminated() {
        return !this.worker.isAlive();
    }

    public int getPoolSize() {
        return 1;
    }

    public int getActiveCount() {
        return 1;
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;
        RunnableScheduledFuture<V> outerTask;

        ScheduledFutureTask(Runnable r, V result, long ns) {
            super(r, result);
            this.outerTask = this;
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = ScheduledSingleThreadExecutor.this.sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, V result, long ns, long period) {
            super(r, result);
            this.outerTask = this;
            this.time = ns;
            this.period = period;
            this.sequenceNumber = ScheduledSingleThreadExecutor.this.sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long ns) {
            super(callable);
            this.outerTask = this;
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = ScheduledSingleThreadExecutor.this.sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - ScheduledSingleThreadExecutor.this.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : ScheduledSingleThreadExecutor.this.triggerTime(-p);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            return cancelled;
        }

        @Override
        public void run() {
            boolean periodic = this.isPeriodic();
            if (!ScheduledSingleThreadExecutor.this.canRunInCurrentRunState(periodic)) {
                this.cancel(false);
            } else if (!periodic) {
                ScheduledFutureTask.super.run();
            } else if (ScheduledFutureTask.super.runAndReset()) {
                this.setNextRunTime();
                ScheduledSingleThreadExecutor.this.reExecutePeriodic(this.outerTask);
            }
        }
    }
}

