/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.fibers.instrument.Log;
import co.paralleluniverse.fibers.instrument.LogLevel;
import co.paralleluniverse.fibers.instrument.QuasarInstrumentor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class InstrumentationTask
extends Task {
    private final ArrayList<FileSet> filesets = new ArrayList();
    private boolean check;
    private boolean verbose;
    private boolean allowMonitors;
    private boolean allowBlocking;
    private boolean debug;
    private boolean writeClasses = true;
    private final ArrayList<WorkListEntry> workList = new ArrayList();

    public void addFileSet(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setAllowMonitors(boolean allowMonitors) {
        this.allowMonitors = allowMonitors;
    }

    public void setAllowBlocking(boolean allowBlocking) {
        this.allowBlocking = allowBlocking;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setWriteClasses(boolean writeClasses) {
        this.writeClasses = writeClasses;
    }

    public void execute() throws BuildException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (FileSet fs : this.filesets) {
                urls.add(fs.getDir().toURI().toURL());
            }
            URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            QuasarInstrumentor instrumentor = new QuasarInstrumentor(true);
            instrumentor.setCheck(this.check);
            instrumentor.setVerbose(this.verbose);
            instrumentor.setDebug(this.debug);
            instrumentor.setAllowMonitors(this.allowMonitors);
            instrumentor.setAllowBlocking(this.allowBlocking);
            instrumentor.setLog(new Log(){

                @Override
                public void log(LogLevel level, String msg, Object ... args) {
                    int msgLevel;
                    switch (level) {
                        case DEBUG: {
                            msgLevel = 4;
                            break;
                        }
                        case INFO: {
                            msgLevel = 2;
                            break;
                        }
                        case WARNING: {
                            msgLevel = 1;
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unhandled log level: " + (Object)((Object)level)));
                        }
                    }
                    InstrumentationTask.this.log((Object)((Object)level) + ": " + String.format(msg, args), msgLevel);
                }

                @Override
                public void error(String msg, Throwable ex) {
                    InstrumentationTask.this.log("ERROR: " + msg, ex, 0);
                }
            });
            for (FileSet fs : this.filesets) {
                String[] includedFiles;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                for (String filename : includedFiles = ds.getIncludedFiles()) {
                    if (!filename.endsWith(".class")) continue;
                    File file = new File(fs.getDir(), filename);
                    if (file.isFile()) {
                        String className = instrumentor.checkClass(cl, file);
                        this.workList.add(new WorkListEntry(className, file));
                        continue;
                    }
                    this.log("File not found: " + filename);
                }
            }
            instrumentor.log(LogLevel.INFO, "Instrumenting " + this.workList.size() + " classes", new Object[0]);
            for (WorkListEntry f : this.workList) {
                this.instrumentClass(cl, instrumentor, f);
            }
        }
        catch (Exception ex) {
            this.log(ex.getMessage());
            throw new BuildException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void instrumentClass(ClassLoader cl, QuasarInstrumentor instrumentor, WorkListEntry entry) {
        block27: {
            if (!instrumentor.shouldInstrument(entry.name)) {
                return;
            }
            try (FileInputStream fis = new FileInputStream(entry.file);){
                byte[] newClass = instrumentor.instrumentClass(cl, entry.name, fis);
                if (!this.writeClasses) break block27;
                try (FileOutputStream fos = new FileOutputStream(entry.file);){
                    fos.write(newClass);
                }
            }
            catch (IOException ex) {
                throw new BuildException("Instrumenting file " + entry.file, (Throwable)ex);
            }
        }
    }

    public static class WorkListEntry {
        public final String name;
        public final File file;

        public WorkListEntry(String name, File file) {
            this.name = name;
            this.file = file;
        }
    }
}

