/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SimpleSuspendableClassifier
implements SuspendableClassifier {
    public static final String PREFIX = "META-INF/";
    public static final String SUSPENDABLES_FILE = "suspendables";
    public static final String SUSPENDABLE_SUPERS_FILE = "suspendable-supers";
    private final Set<String> suspendables = new HashSet<String>();
    private final Set<String> suspendableClasses = new HashSet<String>();
    private final Set<String> suspendableSupers = new HashSet<String>();
    private final Set<String> suspendableSuperInterfaces = new HashSet<String>();

    public SimpleSuspendableClassifier(ClassLoader classLoader) {
        this.readFiles(classLoader, SUSPENDABLES_FILE, this.suspendables, this.suspendableClasses);
        this.readFiles(classLoader, SUSPENDABLE_SUPERS_FILE, this.suspendableSupers, this.suspendableSuperInterfaces);
    }

    public SimpleSuspendableClassifier(ClassLoader classLoader, String[] suspendablesResources, String[] suspendableSupersResources) {
        for (String sus : suspendablesResources) {
            this.readFiles(classLoader, sus, this.suspendables, this.suspendableClasses);
        }
        for (String sus : suspendableSupersResources) {
            this.readFiles(classLoader, sus, this.suspendableSupers, this.suspendableSuperInterfaces);
        }
    }

    SimpleSuspendableClassifier(String suspendablesFileName) {
        this.readSuspendablesFile(suspendablesFileName, this.suspendables, this.suspendableClasses);
    }

    Set<String> getSuspendables() {
        return this.suspendables;
    }

    Set<String> getSuspendableClasses() {
        return this.suspendableClasses;
    }

    private void readFiles(ClassLoader classLoader, String fileName, Set<String> set, Set<String> classSet) {
        try {
            Enumeration<URL> susFiles = classLoader.getResources(PREFIX + fileName);
            while (susFiles.hasMoreElements()) {
                URL file = susFiles.nextElement();
                SimpleSuspendableClassifier.parse(file, set, classSet);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readSuspendablesFile(String fileName, Set<String> set, Set<String> classSet) {
        try {
            SimpleSuspendableClassifier.parse(new File(fileName).toURI().toURL(), set, classSet);
        }
        catch (MalformedURLException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static void parse(URL file, Set<String> set, Set<String> classSet) {
        try (InputStream is = file.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));){
            String line;
            int linenum = 1;
            while ((line = reader.readLine()) != null) {
                String s = line.trim();
                if (!s.isEmpty() && s.charAt(0) != '#') {
                    int index = s.lastIndexOf(46);
                    if (index <= 0) {
                        System.err.println("Can't parse line " + linenum + " in " + file + ": " + line);
                    } else {
                        String className = s.substring(0, index).replace('.', '/');
                        String methodName = s.substring(index + 1);
                        String fullName = className + '.' + methodName;
                        if (methodName.equals("*")) {
                            if (classSet != null) {
                                classSet.add(className);
                            }
                        } else {
                            set.add(fullName);
                        }
                    }
                }
                ++linenum;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isSuspendable(String className, String methodName, String methodDesc) {
        return this.suspendables.contains(className + '.' + methodName + methodDesc) || this.suspendables.contains(className + '.' + methodName) || this.suspendableClasses.contains(className);
    }

    public boolean isSuperSuspendable(String className, String methodName, String methodDesc) {
        return this.suspendableSupers.contains(className + '.' + methodName + methodDesc) || this.suspendableSupers.contains(className + '.' + methodName) || this.suspendableSuperInterfaces.contains(className);
    }

    @Override
    public MethodDatabase.SuspendableType isSuspendable(MethodDatabase db, String sourceName, String sourceDebugInfo, boolean isInterface, String className, String superClassName, String[] interfaces, String methodName, String methodDesc, String methodSignature, String[] methodExceptions) {
        MethodDatabase.ClassEntry ce;
        String fullMethodName = className + '.' + methodName;
        if (this.suspendables.contains(fullMethodName + methodDesc)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (this.suspendables.contains(fullMethodName)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (this.suspendableClasses.contains(className)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (this.suspendableSupers.contains(fullMethodName + methodDesc)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (this.suspendableSupers.contains(fullMethodName)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (this.suspendableSuperInterfaces.contains(className)) {
            return MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (superClassName != null && (ce = db.getOrLoadClassEntry(superClassName)) != null && this.isSuspendable(db, sourceName, sourceDebugInfo, isInterface, superClassName, ce.getSuperName(), ce.getInterfaces(), methodName, methodDesc, methodSignature, methodExceptions) == MethodDatabase.SuspendableType.SUSPENDABLE) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (interfaces != null) {
            for (String iface : interfaces) {
                MethodDatabase.ClassEntry ce2 = db.getOrLoadClassEntry(iface);
                if (ce2 == null || this.isSuspendable(db, ce2.getSourceName(), ce2.getSourceDebugInfo(), ce2.isInterface(), iface, ce2.getSuperName(), ce2.getInterfaces(), methodName, methodDesc, methodSignature, methodExceptions) != MethodDatabase.SuspendableType.SUSPENDABLE) continue;
                return MethodDatabase.SuspendableType.SUSPENDABLE;
            }
        }
        return null;
    }

    public static boolean extendsOrImplements(String superOrIface, MethodDatabase db, String className, String superClassName, String[] interfaces) {
        if (superOrIface == null) {
            throw new IllegalArgumentException("superOrIface is null");
        }
        if (Objects.equals(superOrIface, superClassName)) {
            return true;
        }
        for (String iface : interfaces) {
            if (!Objects.equals(superOrIface, iface)) continue;
            return true;
        }
        if (SimpleSuspendableClassifier.extendsOrImplements(superOrIface, db, superClassName)) {
            return true;
        }
        for (String iface : interfaces) {
            if (!SimpleSuspendableClassifier.extendsOrImplements(superOrIface, db, iface)) continue;
            return true;
        }
        return false;
    }

    private static boolean extendsOrImplements(String superOrIface, MethodDatabase db, String className) {
        if (className == null) {
            return false;
        }
        MethodDatabase.ClassEntry ce = db.getOrLoadClassEntry(className);
        assert (ce != null) : "The class " + className + " couldn't be looked up: it may be missing from the classpath";
        if (Objects.equals(superOrIface, ce.getSuperName())) {
            return true;
        }
        for (String iface : ce.getInterfaces()) {
            if (!Objects.equals(superOrIface, iface)) continue;
            return true;
        }
        if (SimpleSuspendableClassifier.extendsOrImplements(superOrIface, db, ce.getSuperName())) {
            return true;
        }
        for (String iface : ce.getInterfaces()) {
            if (!SimpleSuspendableClassifier.extendsOrImplements(superOrIface, db, iface)) continue;
            return true;
        }
        return false;
    }

    private static MethodDatabase.SuspendableType max(MethodDatabase.SuspendableType a, MethodDatabase.SuspendableType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == MethodDatabase.SuspendableType.SUSPENDABLE || b == MethodDatabase.SuspendableType.SUSPENDABLE) {
            return MethodDatabase.SuspendableType.SUSPENDABLE;
        }
        if (a != b) {
            throw new AssertionError((Object)("a: " + (Object)((Object)a) + " b: " + (Object)((Object)b)));
        }
        return a;
    }
}

