/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.concurrent;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.strands.Strand;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import sun.misc.Unsafe;

@Instrumented
public class StampedLock
implements Serializable {
    private static final long serialVersionUID = -6001602636862214147L;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int SPINS = NCPU > 1 ? 64 : 0;
    private static final int MAX_HEAD_SPINS = NCPU > 1 ? 4096 : 0;
    private static final int OVERFLOW_YIELD_RATE = 7;
    private static final int LG_READERS = 7;
    private static final long RUNIT = 1L;
    private static final long WBIT = 128L;
    private static final long RBITS = 127L;
    private static final long RFULL = 126L;
    private static final long ABITS = 255L;
    private static final long SBITS = -128L;
    private static final long ORIGIN = 256L;
    private static final long INTERRUPTED = 1L;
    private static final int WAITING = -1;
    private static final int CANCELLED = 1;
    private static final int RMODE = 0;
    private static final int WMODE = 1;
    private volatile transient WNode whead;
    private volatile transient WNode wtail;
    transient ReadLockView readLockView;
    transient WriteLockView writeLockView;
    transient ReadWriteLockView readWriteLockView;
    private volatile transient long state = 256L;
    private transient int readerOverflow;
    private static final Unsafe U;
    private static final long STATE;
    private static final long WHEAD;
    private static final long WTAIL;
    private static final long WNEXT;
    private static final long WSTATUS;
    private static final long WCOWAIT;

    public long tryWriteLock() {
        long next;
        long s = this.state;
        return (s & 0xFFL) == 0L && U.compareAndSwapLong(this, STATE, s, next = s + 128L) ? next : 0L;
    }

    public long tryReadLock() {
        long next;
        long s;
        long m;
        do {
            if ((m = (s = this.state) & 0xFFL) != 128L) continue;
            return 0L;
        } while (!(m < 126L ? U.compareAndSwapLong(this, STATE, s, next = s + 1L) : (next = this.tryIncReaderOverflow(s)) != 0L));
        return next;
    }

    public long tryOptimisticRead() {
        long s = this.state;
        return (s & 0x80L) == 0L ? s & 0xFFFFFFFFFFFFFF80L : 0L;
    }

    public boolean validate(long stamp) {
        return (stamp & 0xFFFFFFFFFFFFFF80L) == (U.getLongVolatile(this, STATE) & 0xFFFFFFFFFFFFFF80L);
    }

    public void unlockWrite(long stamp) {
        if (this.state != stamp || (stamp & 0x80L) == 0L) {
            throw new IllegalMonitorStateException();
        }
        this.state = (stamp += 128L) == 0L ? 256L : stamp;
        WNode h = this.whead;
        if (h != null && h.status != 0) {
            this.release(h);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlockRead(long stamp) {
        while (true) {
            long m;
            long s;
            if (((s = this.state) & 0xFFFFFFFFFFFFFF80L) != (stamp & 0xFFFFFFFFFFFFFF80L) || (stamp & 0xFFL) == 0L || (m = s & 0xFFL) == 0L || m == 128L) {
                throw new IllegalMonitorStateException();
            }
            if (m < 126L) {
                WNode h;
                if (!U.compareAndSwapLong(this, STATE, s, s - 1L)) continue;
                if (m != 1L || (h = this.whead) == null || h.status == 0) return;
                this.release(h);
                return;
            }
            if (this.tryDecReaderOverflow(s) != 0L) return;
        }
    }

    public void unlock(long stamp) {
        long m;
        long s;
        long a = stamp & 0xFFL;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L) && (m = s & 0xFFL) != 0L) {
            if (m == 128L) {
                if (a != m) break;
                this.state = (s += 128L) == 0L ? 256L : s;
                WNode h = this.whead;
                if (h != null && h.status != 0) {
                    this.release(h);
                }
                return;
            }
            if (a == 0L || a >= 128L) break;
            if (m < 126L) {
                WNode h;
                if (!U.compareAndSwapLong(this, STATE, s, s - 1L)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return;
            }
            if (this.tryDecReaderOverflow(s) == 0L) continue;
            return;
        }
        throw new IllegalMonitorStateException();
    }

    public long tryConvertToWriteLock(long stamp) {
        long s;
        long a = stamp & 0xFFL;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L)) {
            long next;
            long m = s & 0xFFL;
            if (m == 0L) {
                if (a != 0L) break;
                next = s + 128L;
                if (!U.compareAndSwapLong(this, STATE, s, next)) continue;
                return next;
            }
            if (m == 128L) {
                if (a != m) break;
                return stamp;
            }
            if (m != 1L || a == 0L) break;
            next = s - 1L + 128L;
            if (!U.compareAndSwapLong(this, STATE, s, next)) continue;
            return next;
        }
        return 0L;
    }

    public long tryConvertToReadLock(long stamp) {
        long s;
        long a = stamp & 0xFFL;
        while (((s = this.state) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L)) {
            long next;
            long m = s & 0xFFL;
            if (m == 0L) {
                if (a != 0L) break;
                if (!(m < 126L ? U.compareAndSwapLong(this, STATE, s, next = s + 1L) : (next = this.tryIncReaderOverflow(s)) != 0L)) continue;
                return next;
            }
            if (m == 128L) {
                if (a != m) break;
                this.state = next = s + 129L;
                WNode h = this.whead;
                if (h != null && h.status != 0) {
                    this.release(h);
                }
                return next;
            }
            if (a == 0L || a >= 128L) break;
            return stamp;
        }
        return 0L;
    }

    public long tryConvertToOptimisticRead(long stamp) {
        long s;
        long a = stamp & 0xFFL;
        while (((s = U.getLongVolatile(this, STATE)) & 0xFFFFFFFFFFFFFF80L) == (stamp & 0xFFFFFFFFFFFFFF80L)) {
            long next;
            long m = s & 0xFFL;
            if (m == 0L) {
                if (a != 0L) break;
                return s;
            }
            if (m == 128L) {
                if (a != m) break;
                next = (s += 128L) == 0L ? 256L : s;
                this.state = next;
                WNode h = this.whead;
                if (h != null && h.status != 0) {
                    this.release(h);
                }
                return next;
            }
            if (a == 0L || a >= 128L) break;
            if (m < 126L) {
                WNode h;
                next = s - 1L;
                if (!U.compareAndSwapLong(this, STATE, s, next)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return next & 0xFFFFFFFFFFFFFF80L;
            }
            next = this.tryDecReaderOverflow(s);
            if (next == 0L) continue;
            return next & 0xFFFFFFFFFFFFFF80L;
        }
        return 0L;
    }

    public boolean tryUnlockWrite() {
        long s = this.state;
        if ((s & 0x80L) != 0L) {
            this.state = (s += 128L) == 0L ? 256L : s;
            WNode h = this.whead;
            if (h != null && h.status != 0) {
                this.release(h);
            }
            return true;
        }
        return false;
    }

    public boolean tryUnlockRead() {
        long s;
        long m;
        while ((m = (s = this.state) & 0xFFL) != 0L && m < 128L) {
            if (m < 126L) {
                WNode h;
                if (!U.compareAndSwapLong(this, STATE, s, s - 1L)) continue;
                if (m == 1L && (h = this.whead) != null && h.status != 0) {
                    this.release(h);
                }
                return true;
            }
            if (this.tryDecReaderOverflow(s) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isWriteLocked() {
        return (this.state & 0x80L) != 0L;
    }

    public boolean isReadLocked() {
        return (this.state & 0x7FL) != 0L;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.state = 256L;
    }

    public Lock asReadLock() {
        ReadLockView v = this.readLockView;
        return v != null ? v : (this.readLockView = new ReadLockView());
    }

    public Lock asWriteLock() {
        WriteLockView v = this.writeLockView;
        return v != null ? v : (this.writeLockView = new WriteLockView());
    }

    public ReadWriteLock asReadWriteLock() {
        ReadWriteLockView v = this.readWriteLockView;
        return v != null ? v : (this.readWriteLockView = new ReadWriteLockView());
    }

    final void unstampedUnlockWrite() {
        long s = this.state;
        if ((s & 0x80L) == 0L) {
            throw new IllegalMonitorStateException();
        }
        this.state = (s += 128L) == 0L ? 256L : s;
        WNode h = this.whead;
        if (h != null && h.status != 0) {
            this.release(h);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void unstampedUnlockRead() {
        while (true) {
            long s;
            long m;
            if ((m = (s = this.state) & 0xFFL) == 0L || m >= 128L) {
                throw new IllegalMonitorStateException();
            }
            if (m < 126L) {
                WNode h;
                if (!U.compareAndSwapLong(this, STATE, s, s - 1L)) continue;
                if (m != 1L || (h = this.whead) == null || h.status == 0) return;
                this.release(h);
                return;
            }
            if (this.tryDecReaderOverflow(s) != 0L) return;
        }
    }

    private long tryIncReaderOverflow(long s) {
        if ((s & 0xFFL) == 126L) {
            if (U.compareAndSwapLong(this, STATE, s, s | 0x7FL)) {
                ++this.readerOverflow;
                this.state = s;
                return s;
            }
        } else if ((ThreadLocalRandom.current().nextInt() & 7) == 0 && !Strand.isCurrentFiber()) {
            Thread.yield();
        }
        return 0L;
    }

    private long tryDecReaderOverflow(long s) {
        if ((s & 0xFFL) == 126L) {
            if (U.compareAndSwapLong(this, STATE, s, s | 0x7FL)) {
                long next;
                int r = this.readerOverflow;
                if (r > 0) {
                    this.readerOverflow = r - 1;
                    next = s;
                } else {
                    next = s - 1L;
                }
                this.state = next;
                return next;
            }
        } else if ((ThreadLocalRandom.current().nextInt() & 7) == 0 && !Strand.isCurrentFiber()) {
            Thread.yield();
        }
        return 0L;
    }

    private void release(WNode h) {
        if (h != null) {
            U.compareAndSwapInt(h, WSTATUS, -1, 0);
            WNode q = h.next;
            if (q == null || q.status == 1) {
                WNode t = this.wtail;
                while (t != null && t != h) {
                    if (t.status <= 0) {
                        q = t;
                    }
                    t = t.prev;
                }
            }
            if (q != null) {
                WNode r = q;
                while (true) {
                    Strand w;
                    if ((w = r.strand) != null) {
                        r.strand = null;
                        w.unpark();
                    }
                    if ((r = q.cowait) == null) break;
                    U.compareAndSwapObject(q, WCOWAIT, r, r.cowait);
                }
            }
        }
    }

    private long cancelWaiter(WNode node, WNode group, boolean interrupted) {
        WNode h;
        if (node != null && group != null) {
            WNode q;
            node.status = 1;
            node.strand = null;
            WNode p = group;
            while ((q = p.cowait) != null) {
                if (q.status == 1) {
                    U.compareAndSwapObject(p, WNEXT, q, q.next);
                    continue;
                }
                p = q;
            }
            if (group == node) {
                Strand w;
                WNode r;
                while ((r = node.cowait) != null) {
                    if (!U.compareAndSwapObject(node, WCOWAIT, r, r.cowait) || (w = r.strand) == null) continue;
                    r.strand = null;
                    w.unpark();
                }
                WNode pred = node.prev;
                while (pred != null) {
                    WNode pp;
                    WNode succ;
                    while ((succ = node.next) == null || succ.status == 1) {
                        WNode q2 = null;
                        WNode t = this.wtail;
                        while (t != null && t != node) {
                            if (t.status != 1) {
                                q2 = t;
                            }
                            t = t.prev;
                        }
                        if (succ != q2 && !U.compareAndSwapObject(node, WNEXT, succ, succ = q2)) continue;
                        if (succ != null || node != this.wtail) break;
                        U.compareAndSwapObject(this, WTAIL, node, pred);
                        break;
                    }
                    if (pred.next == node) {
                        U.compareAndSwapObject(pred, WNEXT, node, succ);
                    }
                    if (succ != null && (w = succ.strand) != null) {
                        succ.strand = null;
                        w.unpark();
                    }
                    if (pred.status != 1 || (pp = pred.prev) == null) break;
                    node.prev = pp;
                    U.compareAndSwapObject(pp, WNEXT, pred, succ);
                    pred = pp;
                }
            }
        }
        while ((h = this.whead) != null) {
            long s;
            WNode q = h.next;
            if (q == null || q.status == 1) {
                WNode t = this.wtail;
                while (t != null && t != h) {
                    if (t.status <= 0) {
                        q = t;
                    }
                    t = t.prev;
                }
            }
            if (h != this.whead) continue;
            if (q == null || h.status != 0 || ((s = this.state) & 0xFFL) == 128L || s != 0L && q.mode != 0) break;
            this.release(h);
            break;
        }
        return interrupted || Strand.interrupted() ? 1L : 0L;
    }

    static {
        try {
            U = UtilUnsafe.getUnsafe();
            Class<StampedLock> k = StampedLock.class;
            Class<WNode> wk = WNode.class;
            STATE = U.objectFieldOffset(k.getDeclaredField("state"));
            WHEAD = U.objectFieldOffset(k.getDeclaredField("whead"));
            WTAIL = U.objectFieldOffset(k.getDeclaredField("wtail"));
            WSTATUS = U.objectFieldOffset(wk.getDeclaredField("status"));
            WNEXT = U.objectFieldOffset(wk.getDeclaredField("next"));
            WCOWAIT = U.objectFieldOffset(wk.getDeclaredField("cowait"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=367, methodEnd=371, suspendableCallSites={369}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.acquireWrite(ZJ)J"}, suspendableCallSitesOffsetsAfterInstr={165})
    public long writeLock() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=403, methodEnd=417, suspendableCallSites={412}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.acquireWrite(ZJ)J"}, suspendableCallSitesOffsetsAfterInstr={268})
    public long tryWriteLock(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=435, methodEnd=440, suspendableCallSites={436}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.acquireWrite(ZJ)J"}, suspendableCallSitesOffsetsAfterInstr={103})
    public long writeLockInterruptibly() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=454, methodEnd=458, suspendableCallSites={456}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.acquireRead(ZJ)J"}, suspendableCallSitesOffsetsAfterInstr={163})
    public long readLock() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=497, methodEnd=515, suspendableCallSites={510}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.acquireRead(ZJ)J"}, suspendableCallSitesOffsetsAfterInstr={354})
    public long tryReadLock(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=533, methodEnd=538, suspendableCallSites={534}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.acquireRead(ZJ)J"}, suspendableCallSitesOffsetsAfterInstr={103})
    public long readLockInterruptibly() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1065, methodEnd=1133, suspendableCallSites={1128}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.park(J)V"}, suspendableCallSitesOffsetsAfterInstr={745})
    private long acquireWrite(boolean var1_1, long var2_2) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1146, methodEnd=1273, suspendableCallSites={1209, 1268}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.park(J)V"}, suspendableCallSitesOffsetsAfterInstr={785, 1404})
    private long acquireRead(boolean var1_1, long var2_2) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1389, methodEnd=1393, suspendableCallSites={1390, 1392}, suspendableCallSiteNames={"co/paralleluniverse/strands/Strand.parkNanos(J)V", "co/paralleluniverse/strands/Strand.park()V"}, suspendableCallSitesOffsetsAfterInstr={92, 122})
    private static void park(long var0) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final class ReadWriteLockView
    implements ReadWriteLock {
        ReadWriteLockView() {
        }

        @Override
        public Lock readLock() {
            return StampedLock.this.asReadLock();
        }

        @Override
        public Lock writeLock() {
            return StampedLock.this.asWriteLock();
        }
    }

    @Instrumented
    final class WriteLockView
    implements Lock {
        WriteLockView() {
        }

        @Override
        public boolean tryLock() {
            return StampedLock.this.tryWriteLock() != 0L;
        }

        @Override
        public void unlock() {
            StampedLock.this.unstampedUnlockWrite();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=907, methodEnd=908, suspendableCallSites={907}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.writeLock()J"}, suspendableCallSitesOffsetsAfterInstr={76})
        public void lock() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=912, methodEnd=913, suspendableCallSites={912}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.writeLockInterruptibly()J"}, suspendableCallSitesOffsetsAfterInstr={76})
        public void lockInterruptibly() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=922, methodEnd=922, suspendableCallSites={922}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.tryWriteLock(JLjava/util/concurrent/TimeUnit;)J"}, suspendableCallSitesOffsetsAfterInstr={148})
        public boolean tryLock(long var1_1, TimeUnit var3_2) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @Instrumented
    final class ReadLockView
    implements Lock {
        ReadLockView() {
        }

        @Override
        public boolean tryLock() {
            return StampedLock.this.tryReadLock() != 0L;
        }

        @Override
        public void unlock() {
            StampedLock.this.unstampedUnlockRead();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=877, methodEnd=878, suspendableCallSites={877}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.readLock()J"}, suspendableCallSitesOffsetsAfterInstr={76})
        public void lock() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=882, methodEnd=883, suspendableCallSites={882}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.readLockInterruptibly()J"}, suspendableCallSitesOffsetsAfterInstr={76})
        public void lockInterruptibly() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        @Suspendable
        @Instrumented(methodOptimized=false, methodStart=892, methodEnd=892, suspendableCallSites={892}, suspendableCallSiteNames={"co/paralleluniverse/strands/concurrent/StampedLock.tryReadLock(JLjava/util/concurrent/TimeUnit;)J"}, suspendableCallSitesOffsetsAfterInstr={148})
        public boolean tryLock(long var1_1, TimeUnit var3_2) throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static final class WNode {
        volatile WNode prev;
        volatile WNode next;
        volatile WNode cowait;
        volatile Strand strand;
        volatile int status;
        final int mode;

        WNode(int m, WNode p) {
            this.mode = m;
            this.prev = p;
        }
    }
}

