/*
 * Decompiled with CFR 0.152.
 */
package org.cliffc.high_scale_lib;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.cliffc.high_scale_lib.UtilUnsafe;
import sun.misc.Unsafe;

public class ScalableReadWriteLock
implements Serializable {
    private static final boolean FIRST_WRITER_SPINS = false;
    private static final AtomicReferenceFieldUpdater<ScalableReadWriteLock, CAT> _catUpdater = AtomicReferenceFieldUpdater.newUpdater(ScalableReadWriteLock.class, CAT.class, "_cat");
    private static final AtomicIntegerFieldUpdater<ScalableReadWriteLock> _writerUpdater = AtomicIntegerFieldUpdater.newUpdater(ScalableReadWriteLock.class, "_writer");
    private volatile int _writer;
    private volatile CAT _cat = new CAT(null, 4, 0);
    private final Collection<Thread> _waitingReaders = new NonBlockingHashSet<Thread>();
    private final Queue<Thread> _waitingWriters = new ConcurrentLinkedQueue<Thread>();
    private int _oldWriters = 0;

    public void read() {
        try {
            this.read1(false);
        }
        catch (InterruptedException ex) {
            throw new AssertionError();
        }
    }

    public void readInterruptably() throws InterruptedException {
        this.read1(true);
    }

    private void read1(boolean interrupt) throws InterruptedException {
        if (this.tryRead()) {
            return;
        }
        boolean wasInterrupted = false;
        Thread current = Thread.currentThread();
        this._waitingReaders.add(current);
        while (true) {
            if (this._writer != 0) {
                LockSupport.park(this);
                if (Thread.interrupted()) {
                    if (interrupt) {
                        this._waitingReaders.remove(current);
                        throw new InterruptedException();
                    }
                    wasInterrupted = true;
                }
                if (this._waitingReaders.contains(current)) continue;
                break;
            }
            int hash = ScalableReadWriteLock.hash(current);
            CAT cat = this._cat;
            cat.add(1, hash, this);
            if (this._writer == 0) {
                this._waitingReaders.remove(current);
                break;
            }
            cat.add(-1, hash, this);
        }
        if (wasInterrupted) {
            current.interrupt();
        }
    }

    public boolean tryRead() {
        if (this._writer != 0) {
            return false;
        }
        CAT cat = this._cat;
        int hash = ScalableReadWriteLock.hash();
        cat.add(1, hash, this);
        if (this._writer != 0) {
            cat.add(-1, hash, this);
            return false;
        }
        return true;
    }

    public void unlockRead() {
        Thread firstWriter;
        this._cat.add(-1, ScalableReadWriteLock.hash(), this);
        if (this._cat.isZero() && (firstWriter = this._waitingWriters.poll()) != null) {
            LockSupport.unpark(firstWriter);
        }
    }

    public void write() {
        try {
            this.write1(false);
        }
        catch (InterruptedException ex) {
            throw new AssertionError();
        }
    }

    public void writeInterruptably() throws InterruptedException {
        this.write1(true);
    }

    private void write1(boolean interrupt) throws InterruptedException {
        if (this.tryWrite()) {
            return;
        }
        boolean wasInterrupted = false;
        Thread current = Thread.currentThread();
        this._waitingWriters.add(current);
        block0: while (true) {
            boolean first = false;
            while (true) {
                if (this._writer != 0 || !_writerUpdater.compareAndSet(this, 0, 1)) {
                    continue;
                }
                first = true;
                if (this._writer != 0) break;
            }
            if (first) {
                // empty if block
            }
            do {
                LockSupport.park(this);
                if (Thread.interrupted()) {
                    if (interrupt) {
                        this._waitingWriters.remove(current);
                        throw new InterruptedException();
                    }
                    wasInterrupted = true;
                }
                if (this._writer == 0) continue block0;
            } while (this._waitingWriters.element() == current || !this._cat.isZero());
            break;
        }
        assert (this._writer != 0 && this._cat.isZero());
        if (wasInterrupted) {
            current.interrupt();
        }
    }

    public boolean tryWrite() {
        if (this._writer != 0) {
            return false;
        }
        if (_writerUpdater.compareAndSet(this, 0, 1)) {
            if (this._cat.isZero()) {
                return true;
            }
            this._writer = 0;
        }
        return false;
    }

    public void unlockWrite() {
        boolean released;
        if (this._oldWriters > 0 && this.releaseNextWriter()) {
            return;
        }
        int readerCount = 0;
        Iterator<Thread> it = this._waitingReaders.iterator();
        while (it.hasNext()) {
            Thread t = it.next();
            ++readerCount;
            it.remove();
            LockSupport.unpark(t);
        }
        if (readerCount > 0) {
            this._cat.add(readerCount, ScalableReadWriteLock.hash(), this);
        }
        this._oldWriters = this._waitingWriters.size();
        if (readerCount <= 0 && !(released = this.releaseNextWriter())) {
            this._writer = 0;
            for (Thread t : this._waitingReaders) {
                LockSupport.unpark(t);
            }
            this.releaseNextWriter();
        }
    }

    private boolean releaseNextWriter() {
        Thread nextWriter = this._waitingWriters.poll();
        if (this._oldWriters > 0) {
            --this._oldWriters;
        }
        if (nextWriter != null) {
            LockSupport.unpark(nextWriter);
            return true;
        }
        this._oldWriters = 0;
        return false;
    }

    public int getLock() {
        if (this._writer != 0) {
            return -1;
        }
        if (this._cat.sum() != 0L) {
            return 1;
        }
        return 0;
    }

    public int internalSize() {
        return this._cat._t.length;
    }

    public void print() {
        System.out.print(this._writer);
        System.out.print(" ");
        this._cat.print();
        System.out.println();
    }

    private boolean CAS_cat(CAT oldcat, CAT newcat) {
        return _catUpdater.compareAndSet(this, oldcat, newcat);
    }

    private static final int hash() {
        return ScalableReadWriteLock.hash(Thread.currentThread());
    }

    private static final int hash(Thread thread) {
        int h = System.identityHashCode(thread);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h << 2;
    }

    private static class SPW {
        private int count = 0;

        private SPW() {
        }

        void spin(boolean interrupt) throws InterruptedException {
            if (this.count++ > 32) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {}
            } else if (this.count > 12) {
                Thread.yield();
            } else {
                for (int i = 0; i < 2 << this.count; ++i) {
                    if (!interrupt || !Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
            }
        }
    }

    private static class CAT
    implements Serializable {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
        private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);
        private static final AtomicLongFieldUpdater<CAT> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CAT.class, "_resizers");
        private static final int MAX_SPIN = 2;
        private volatile CAT _next;
        private volatile long _sum_cache;
        private final long[] _t;
        volatile long _resizers;

        CAT(CAT next, int sz, int init) {
            this._next = next;
            this._sum_cache = Long.MIN_VALUE;
            this._t = new long[sz];
            this._t[0] = init;
        }

        private static long rawIndex(long[] ary, int i) {
            assert (i >= 0 && i < ary.length);
            return _Lbase + i * _Lscale;
        }

        private static final boolean CAS(long[] A, int idx, long old, long nnn) {
            return _unsafe.compareAndSwapLong(A, CAT.rawIndex(A, idx), old, nnn);
        }

        public long add(int x, int hash, ScalableReadWriteLock master) {
            long[] t = this._t;
            int idx = hash & t.length - 1;
            long old = t[idx];
            if (x > 0 && old > Long.MAX_VALUE - (long)x) {
                throw new Error("Maximum lock count exceeded");
            }
            boolean ok = CAT.CAS(t, idx, old, old + (long)x);
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
            if (ok) {
                return old;
            }
            int cnt = 0;
            while (!CAT.CAS(t, idx, old = t[idx], old + (long)x)) {
                ++cnt;
            }
            if (cnt < 2) {
                return old;
            }
            if (t.length >= 0x100000) {
                return old;
            }
            long r = this._resizers;
            int newbytes = t.length << 1 << 3;
            while (!_resizerUpdater.compareAndSet(this, r, r + (long)newbytes)) {
                r = this._resizers;
            }
            r += (long)newbytes;
            if (master._cat != this) {
                return old;
            }
            if (r >> 17 != 0L) {
                try {
                    Thread.sleep(r >> 17);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (master._cat != this) {
                    return old;
                }
            }
            CAT newcat = new CAT(this, t.length * 2, 0);
            master.CAS_cat(this, newcat);
            return old;
        }

        private long sum() {
            long sum = this._sum_cache;
            if (sum != Integer.MIN_VALUE) {
                return sum;
            }
            sum = this._next == null ? 0L : this._next.sum();
            long[] t = this._t;
            for (int i = 0; i < t.length; ++i) {
                sum += t[i];
            }
            return sum;
        }

        public boolean isZero() {
            if (this.sum() == 0L) {
                if (this._next != null) {
                    this._next = null;
                }
                long[] t = this._t;
                for (int i = 0; i < t.length; ++i) {
                    t[i] = 0L;
                }
                return true;
            }
            return false;
        }

        public void awaitZero(boolean interrupt) throws InterruptedException {
            SPW sw = new SPW();
            while (!this.isZero()) {
                sw.spin(interrupt);
            }
        }

        public void print() {
            long[] t = this._t;
            for (int i = 1; i < t.length; ++i) {
                System.out.print("," + t[i]);
            }
            System.out.print("]");
            if (this._next != null) {
                this._next.print();
            }
        }
    }
}

