/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.util.Json;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OptionalUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(OptionalUtils.class);

    public static boolean _isOptionalType(JavaType jtype) {
        return Arrays.asList("com.google.common.base.Optional", "java.util.Optional").contains(jtype.getRawClass().getCanonicalName());
    }

    public static AnnotatedType unwrapOptional(AnnotatedType type) {
        if (type == null) {
            return type;
        }
        try {
            JavaType jtype = type.getType() instanceof JavaType ? (JavaType)type.getType() : Json.mapper().constructType(type.getType());
            if (OptionalUtils._isOptionalType(jtype)) {
                AnnotatedType aType = new AnnotatedType().type((Type)jtype.containedType(0)).name(type.getName()).parent(type.getParent()).jsonUnwrappedHandler(type.getJsonUnwrappedHandler()).skipOverride(true).schemaProperty(type.isSchemaProperty()).ctxAnnotations(type.getCtxAnnotations()).resolveAsRef(type.isResolveAsRef()).jsonViewAnnotation(type.getJsonViewAnnotation()).skipSchemaName(type.isSkipSchemaName()).skipJsonIdentity(type.isSkipJsonIdentity()).propertyName(type.getPropertyName());
                return aType;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error unwrapping optional", (Throwable)e);
            return null;
        }
    }
}

