/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import com.mongodb.lang.Nullable;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.ValidationOptionsConverter;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

@DataObject(generateConverter=true)
public final class ValidationOptions {
    private JsonObject validator = new JsonObject();
    private ValidationLevel validationLevel;
    private ValidationAction validationAction;

    public ValidationOptions() {
        this.validator = new JsonObject();
        this.validationLevel = ValidationLevel.STRICT;
        this.validationAction = ValidationAction.ERROR;
    }

    public ValidationOptions(ValidationOptions validationOptions) {
        this.validator = validationOptions.getValidator();
        this.validationLevel = validationOptions.getValidationLevel();
        this.validationAction = validationOptions.getValidationAction();
    }

    public ValidationOptions(JsonObject json) {
        ValidationOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ValidationOptionsConverter.toJson(this, json);
        return json;
    }

    public com.mongodb.client.model.ValidationOptions toMongoDriverObject() {
        return new com.mongodb.client.model.ValidationOptions().validator((Bson)BsonDocument.parse((String)this.validator.encode())).validationAction(this.validationAction).validationLevel(this.validationLevel);
    }

    @Nullable
    public JsonObject getValidator() {
        return this.validator;
    }

    public ValidationOptions setValidator(@Nullable JsonObject validator) {
        this.validator = validator;
        return this;
    }

    @Nullable
    public ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    public ValidationOptions setValidationLevel(@Nullable ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    @Nullable
    public ValidationAction getValidationAction() {
        return this.validationAction;
    }

    public ValidationOptions setValidationAction(@Nullable ValidationAction validationAction) {
        this.validationAction = validationAction;
        return this;
    }

    public String toString() {
        return "ValidationOptions{validator=" + this.validator + ", validationLevel=" + this.validationLevel + ", validationAction=" + this.validationAction + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationOptions that = (ValidationOptions)o;
        return Objects.equals(this.getValidator(), that.getValidator()) && this.getValidationLevel() == that.getValidationLevel() && this.getValidationAction() == that.getValidationAction();
    }

    public int hashCode() {
        return Objects.hash(this.getValidator(), this.getValidationLevel(), this.getValidationAction());
    }
}

