/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public class PublisherAdapter<T>
implements ReadStream<T> {
    private final ContextInternal context;
    private final Publisher<T> publisher;
    private final InboundBuffer<T> internalQueue;
    private final int batchSize;
    private State state;
    private int inFlight;
    private Handler<T> handler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private Subscription subscription;

    public PublisherAdapter(ContextInternal context, Publisher<T> publisher, int batchSize) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(publisher, "publisher is null");
        this.context = context;
        this.publisher = publisher;
        this.batchSize = batchSize > 0 ? batchSize : 256;
        this.internalQueue = new InboundBuffer((Context)context);
        this.state = State.IDLE;
    }

    public synchronized ReadStream<T> exceptionHandler(Handler<Throwable> handler) {
        if (this.state != State.STOPPED) {
            this.exceptionHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadStream<T> handler(Handler<T> handler) {
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            if (this.state == State.STOPPED) {
                return this;
            }
        }
        if (handler == null) {
            this.stop();
            this.context.runOnContext(v -> this.handleEnd());
        } else {
            publisherAdapter = this;
            synchronized (publisherAdapter) {
                this.handler = handler;
            }
            this.internalQueue.handler(this::handleOut);
            boolean subscribe = false;
            PublisherAdapter publisherAdapter2 = this;
            synchronized (publisherAdapter2) {
                if (this.state == State.IDLE) {
                    this.state = State.STARTED;
                    subscribe = true;
                }
            }
            if (subscribe) {
                this.publisher.subscribe((org.reactivestreams.Subscriber)new Subscriber());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadStream<T> pause() {
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            if (this.state == State.STOPPED) {
                return this;
            }
        }
        this.internalQueue.pause();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadStream<T> resume() {
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            if (this.state == State.STOPPED) {
                return this;
            }
        }
        this.internalQueue.resume();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReadStream<T> fetch(long amount) {
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            if (this.state == State.STOPPED) {
                return this;
            }
        }
        this.internalQueue.fetch(amount);
        return this;
    }

    public synchronized ReadStream<T> endHandler(Handler<Void> endHandler) {
        if (this.state != State.STOPPED) {
            this.endHandler = endHandler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIn(T item) {
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            if (this.state == State.STOPPED) {
                return;
            }
            ++this.inFlight;
        }
        this.internalQueue.write(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOut(T item) {
        State s;
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            if (this.state == State.STOPPED) {
                return;
            }
            --this.inFlight;
        }
        this.handler.handle(item);
        PublisherAdapter publisherAdapter2 = this;
        synchronized (publisherAdapter2) {
            if (this.inFlight != 0) {
                return;
            }
            s = this.state;
        }
        if (s == State.EXHAUSTED) {
            this.stop();
            this.handleEnd();
        } else {
            this.requestMore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnComplete() {
        boolean stop;
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            if (this.state == State.STOPPED) {
                return;
            }
            this.state = State.EXHAUSTED;
            stop = this.inFlight == 0;
        }
        if (stop) {
            this.stop();
            this.handleEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Throwable cause) {
        Handler<Throwable> h;
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            h = this.state != State.STOPPED ? this.exceptionHandler : null;
        }
        if (h != null) {
            this.stop();
            h.handle((Object)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMore() {
        Subscription s;
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            if (this.state == State.STOPPED) {
                return;
            }
            s = this.subscription;
        }
        s.request((long)this.batchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEnd() {
        Handler<Void> h;
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            h = this.endHandler;
        }
        if (h != null) {
            h.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Subscription s;
        PublisherAdapter publisherAdapter = this;
        synchronized (publisherAdapter) {
            this.state = State.STOPPED;
            s = this.subscription;
        }
        this.internalQueue.handler(null).drainHandler(null);
        if (s != null) {
            s.cancel();
        }
    }

    private class Subscriber
    implements org.reactivestreams.Subscriber<T> {
        private Subscriber() {
        }

        public void onSubscribe(Subscription subscription) {
            PublisherAdapter.this.context.runOnContext(v -> {
                PublisherAdapter publisherAdapter = PublisherAdapter.this;
                synchronized (publisherAdapter) {
                    PublisherAdapter.this.subscription = subscription;
                }
                PublisherAdapter.this.requestMore();
            });
        }

        public void onNext(T t) {
            PublisherAdapter.this.context.runOnContext(v -> PublisherAdapter.this.handleIn(t));
        }

        public void onError(Throwable t) {
            PublisherAdapter.this.context.runOnContext(v -> PublisherAdapter.this.handleException(t));
        }

        public void onComplete() {
            PublisherAdapter.this.context.runOnContext(v -> PublisherAdapter.this.handleOnComplete());
        }
    }

    private static enum State {
        IDLE,
        STARTED,
        EXHAUSTED,
        STOPPED;

    }
}

