/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.spi;

import io.vertx.core.Closeable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.sqlclient.SqlConnection;
import java.util.ArrayList;
import java.util.List;

public interface ConnectionFactory
extends Closeable {
    public static ConnectionFactory roundRobinSelector(final List<ConnectionFactory> factories) {
        if (factories.size() == 1) {
            return factories.get(0);
        }
        return new ConnectionFactory(){
            int idx = 0;

            @Override
            public Future<SqlConnection> connect(Context context) {
                ConnectionFactory f = (ConnectionFactory)factories.get(this.idx);
                this.idx = (this.idx + 1) % factories.size();
                return f.connect(context);
            }

            public void close(Promise<Void> promise) {
                ArrayList<Future> list = new ArrayList<Future>(factories.size());
                for (ConnectionFactory factory : factories) {
                    Promise p = Promise.promise();
                    factory.close(p);
                    list.add(p.future());
                }
                CompositeFuture.all(list).mapEmpty().onComplete(promise);
            }
        };
    }

    public Future<SqlConnection> connect(Context var1);
}

