/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;

public class RedisAPIImpl
implements RedisAPI {
    private static final Logger LOG = LoggerFactory.getLogger(RedisAPIImpl.class);
    private final Redis redis;
    private final RedisConnection connection;

    public RedisAPIImpl(RedisConnection connection) {
        this.connection = connection;
        this.redis = null;
    }

    public RedisAPIImpl(Redis redis) {
        this.connection = null;
        this.redis = redis;
    }

    @Override
    public Future<Response> send(Command cmd, String ... args) {
        Promise promise = Promise.promise();
        Request req = Request.cmd(cmd);
        if (args != null) {
            for (String o : args) {
                if (o == null) {
                    req.nullArg();
                    continue;
                }
                req.arg(o);
            }
        }
        if (this.redis != null) {
            this.redis.send(req, (Handler<AsyncResult<Response>>)promise);
        } else if (this.connection != null) {
            this.connection.send(req, (Handler<AsyncResult<Response>>)promise);
        }
        return promise.future();
    }

    @Override
    public void close() {
        if (this.redis != null) {
            this.redis.close();
        } else if (this.connection != null) {
            this.connection.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
        }
    }
}

