/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableListMultimap;
import graphql.execution.MergedField;
import graphql.execution.ResultPath;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.normalized.ExecutableNormalizedField;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldsContainer;
import java.util.List;
import java.util.Map;

@Internal
public class ExecutableNormalizedOperation {
    private final OperationDefinition.Operation operation;
    private final String operationName;
    private final List<ExecutableNormalizedField> topLevelFields;
    private final ImmutableListMultimap<Field, ExecutableNormalizedField> fieldToNormalizedField;
    private final Map<ExecutableNormalizedField, MergedField> normalizedFieldToMergedField;
    private final ImmutableListMultimap<FieldCoordinates, ExecutableNormalizedField> coordinatesToNormalizedFields;

    public ExecutableNormalizedOperation(OperationDefinition.Operation operation, String operationName, List<ExecutableNormalizedField> topLevelFields, ImmutableListMultimap<Field, ExecutableNormalizedField> fieldToNormalizedField, Map<ExecutableNormalizedField, MergedField> normalizedFieldToMergedField, ImmutableListMultimap<FieldCoordinates, ExecutableNormalizedField> coordinatesToNormalizedFields) {
        this.operation = operation;
        this.operationName = operationName;
        this.topLevelFields = topLevelFields;
        this.fieldToNormalizedField = fieldToNormalizedField;
        this.normalizedFieldToMergedField = normalizedFieldToMergedField;
        this.coordinatesToNormalizedFields = coordinatesToNormalizedFields;
    }

    public OperationDefinition.Operation getOperation() {
        return this.operation;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ImmutableListMultimap<FieldCoordinates, ExecutableNormalizedField> getCoordinatesToNormalizedFields() {
        return this.coordinatesToNormalizedFields;
    }

    public List<ExecutableNormalizedField> getTopLevelFields() {
        return this.topLevelFields;
    }

    public ImmutableListMultimap<Field, ExecutableNormalizedField> getFieldToNormalizedField() {
        return this.fieldToNormalizedField;
    }

    public List<ExecutableNormalizedField> getNormalizedFields(Field field) {
        return this.fieldToNormalizedField.get((Object)field);
    }

    public Map<ExecutableNormalizedField, MergedField> getNormalizedFieldToMergedField() {
        return this.normalizedFieldToMergedField;
    }

    public MergedField getMergedField(ExecutableNormalizedField executableNormalizedField) {
        return this.normalizedFieldToMergedField.get(executableNormalizedField);
    }

    public ExecutableNormalizedField getNormalizedField(MergedField mergedField, GraphQLFieldsContainer fieldsContainer, ResultPath resultPath) {
        ImmutableCollection executableNormalizedFields = this.fieldToNormalizedField.get((Object)mergedField.getSingleField());
        List<String> keysOnlyPath = resultPath.getKeysOnly();
        for (ExecutableNormalizedField executableNormalizedField : executableNormalizedFields) {
            if (!executableNormalizedField.getListOfResultKeys().equals(keysOnlyPath) || !executableNormalizedField.getObjectTypeNames().contains(fieldsContainer.getName())) continue;
            return executableNormalizedField;
        }
        return (ExecutableNormalizedField)Assert.assertShouldNeverHappen("normalized field not found", new Object[0]);
    }
}

