/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.Schema;
import io.vertx.json.schema.SchemaRouter;
import io.vertx.json.schema.common.ValidatorFactory;
import io.vertx.json.schema.draft201909.Draft201909SchemaParser;
import io.vertx.json.schema.draft7.Draft7SchemaParser;
import io.vertx.json.schema.openapi3.OpenAPI3SchemaParser;
import java.util.function.Predicate;

@VertxGen
public interface SchemaParser {
    public Schema parse(JsonObject var1);

    public Schema parse(JsonObject var1, JsonPointer var2);

    public Schema parse(Boolean var1);

    public Schema parse(Boolean var1, JsonPointer var2);

    public Schema parseFromString(String var1);

    public Schema parseFromString(String var1, JsonPointer var2);

    public SchemaRouter getSchemaRouter();

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public SchemaParser withValidatorFactory(ValidatorFactory var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public SchemaParser withStringFormatValidator(String var1, Predicate<String> var2);

    public static SchemaParser createOpenAPI3SchemaParser(SchemaRouter router) {
        return OpenAPI3SchemaParser.create(router);
    }

    public static SchemaParser createDraft7SchemaParser(SchemaRouter router) {
        return Draft7SchemaParser.create(router);
    }

    public static SchemaParser createDraft201909SchemaParser(SchemaRouter router) {
        return Draft201909SchemaParser.create(router);
    }
}

