/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSBucket;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSDownloadStream;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSUploadStream;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadPublisher;
import com.mongodb.reactivestreams.client.internal.GridFSDownloadPublisherImpl;
import com.mongodb.reactivestreams.client.internal.GridFSFindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.GridFSUploadPublisherImpl;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.nio.ByteBuffer;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

public final class GridFSBucketImpl
implements GridFSBucket {
    private final AsyncGridFSBucket wrapped;

    public GridFSBucketImpl(AsyncGridFSBucket wrapped) {
        this.wrapped = (AsyncGridFSBucket)Assertions.notNull((String)"GridFSBucket", (Object)wrapped);
    }

    @Override
    public String getBucketName() {
        return this.wrapped.getBucketName();
    }

    @Override
    public int getChunkSizeBytes() {
        return this.wrapped.getChunkSizeBytes();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.wrapped.withChunkSizeBytes(chunkSizeBytes));
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new GridFSBucketImpl(this.wrapped.withReadPreference(readPreference));
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new GridFSBucketImpl(this.wrapped.withWriteConcern(writeConcern));
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new GridFSBucketImpl(this.wrapped.withReadConcern(readConcern));
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options) {
        return this.executeUploadFromPublisher(this.wrapped.openUploadStream((BsonValue)new BsonObjectId(), filename, options), source).withObjectId();
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(BsonValue id, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(id, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(BsonValue id, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options) {
        return this.executeUploadFromPublisher(this.wrapped.openUploadStream(id, filename, options), source);
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(ClientSession clientSession, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(clientSession, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(ClientSession clientSession, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options) {
        return this.executeUploadFromPublisher(this.wrapped.openUploadStream(clientSession.getWrapped(), (BsonValue)new BsonObjectId(), filename, options), source).withObjectId();
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(ClientSession clientSession, BsonValue id, String filename, Publisher<ByteBuffer> source) {
        return this.uploadFromPublisher(clientSession, id, filename, source, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(ClientSession clientSession, BsonValue id, String filename, Publisher<ByteBuffer> source, GridFSUploadOptions options) {
        return this.executeUploadFromPublisher(this.wrapped.openUploadStream(clientSession.getWrapped(), id, filename, options), source);
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ObjectId id) {
        return this.executeDownloadToPublisher(this.wrapped.openDownloadStream(id));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(BsonValue id) {
        return this.executeDownloadToPublisher(this.wrapped.openDownloadStream(id));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(String filename) {
        return this.executeDownloadToPublisher(this.wrapped.openDownloadStream(filename));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(String filename, GridFSDownloadOptions options) {
        return this.executeDownloadToPublisher(this.wrapped.openDownloadStream(filename, options));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, ObjectId id) {
        return this.executeDownloadToPublisher(this.wrapped.openDownloadStream(clientSession.getWrapped(), id));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, BsonValue id) {
        return this.executeDownloadToPublisher(this.wrapped.openDownloadStream(clientSession.getWrapped(), id));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, String filename) {
        return this.executeDownloadToPublisher(this.wrapped.openDownloadStream(clientSession.getWrapped(), filename));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        return this.executeDownloadToPublisher(this.wrapped.openDownloadStream(clientSession.getWrapped(), filename, options));
    }

    private GridFSDownloadPublisher executeDownloadToPublisher(AsyncGridFSDownloadStream gridFSDownloadStream) {
        return new GridFSDownloadPublisherImpl(gridFSDownloadStream);
    }

    private GridFSUploadPublisherImpl executeUploadFromPublisher(AsyncGridFSUploadStream gridFSUploadStream, Publisher<ByteBuffer> source) {
        return new GridFSUploadPublisherImpl(gridFSUploadStream, source);
    }

    @Override
    public GridFSFindPublisher find() {
        return new GridFSFindPublisherImpl(this.wrapped.find());
    }

    @Override
    public GridFSFindPublisher find(Bson filter) {
        return new GridFSFindPublisherImpl(this.wrapped.find(filter));
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession) {
        return new GridFSFindPublisherImpl(this.wrapped.find(clientSession.getWrapped()));
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession, Bson filter) {
        return new GridFSFindPublisherImpl(this.wrapped.find(clientSession.getWrapped(), filter));
    }

    @Override
    public Publisher<Void> delete(ObjectId id) {
        return Publishers.publish(callback -> this.wrapped.delete(id, callback));
    }

    @Override
    public Publisher<Void> delete(BsonValue id) {
        return Publishers.publish(callback -> this.wrapped.delete(id, callback));
    }

    @Override
    public Publisher<Void> delete(ClientSession clientSession, ObjectId id) {
        return Publishers.publish(callback -> this.wrapped.delete(clientSession.getWrapped(), id, callback));
    }

    @Override
    public Publisher<Void> delete(ClientSession clientSession, BsonValue id) {
        return Publishers.publish(callback -> this.wrapped.delete(clientSession.getWrapped(), id, callback));
    }

    @Override
    public Publisher<Void> rename(ObjectId id, String newFilename) {
        return Publishers.publish(callback -> this.wrapped.rename(id, newFilename, callback));
    }

    @Override
    public Publisher<Void> rename(BsonValue id, String newFilename) {
        return Publishers.publish(callback -> this.wrapped.rename(id, newFilename, callback));
    }

    @Override
    public Publisher<Void> rename(ClientSession clientSession, ObjectId id, String newFilename) {
        return Publishers.publish(callback -> this.wrapped.rename(clientSession.getWrapped(), id, newFilename, callback));
    }

    @Override
    public Publisher<Void> rename(ClientSession clientSession, BsonValue id, String newFilename) {
        return Publishers.publish(callback -> this.wrapped.rename(clientSession.getWrapped(), id, newFilename, callback));
    }

    @Override
    public Publisher<Void> drop() {
        return Publishers.publish(arg_0 -> ((AsyncGridFSBucket)this.wrapped).drop(arg_0));
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return Publishers.publish(callback -> this.wrapped.drop(clientSession.getWrapped(), callback));
    }
}

