/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.ServerAddress;
import com.mongodb.TagSet;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class ClusterDescriptionHelper {
    public static Set<ServerDescription> getAll(ClusterDescription clusterDescription) {
        TreeSet<ServerDescription> serverDescriptionSet = new TreeSet<ServerDescription>((o1, o2) -> {
            int val = o1.getAddress().getHost().compareTo(o2.getAddress().getHost());
            if (val != 0) {
                return val;
            }
            return Integer.compare(o1.getAddress().getPort(), o2.getAddress().getPort());
        });
        serverDescriptionSet.addAll(clusterDescription.getServerDescriptions());
        return Collections.unmodifiableSet(serverDescriptionSet);
    }

    public static ServerDescription getByServerAddress(ClusterDescription clusterDescription, ServerAddress serverAddress) {
        for (ServerDescription cur : clusterDescription.getServerDescriptions()) {
            if (!cur.isOk() || !cur.getAddress().equals(serverAddress)) continue;
            return cur;
        }
        return null;
    }

    public static List<ServerDescription> getPrimaries(ClusterDescription clusterDescription) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, ServerDescription::isPrimary);
    }

    public static List<ServerDescription> getSecondaries(ClusterDescription clusterDescription) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, ServerDescription::isSecondary);
    }

    public static List<ServerDescription> getSecondaries(ClusterDescription clusterDescription, TagSet tagSet) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, serverDescription -> serverDescription.isSecondary() && serverDescription.hasTags(tagSet));
    }

    public static List<ServerDescription> getAny(ClusterDescription clusterDescription) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, ServerDescription::isOk);
    }

    public static List<ServerDescription> getAnyPrimaryOrSecondary(ClusterDescription clusterDescription) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, serverDescription -> serverDescription.isPrimary() || serverDescription.isSecondary());
    }

    public static List<ServerDescription> getAnyPrimaryOrSecondary(ClusterDescription clusterDescription, TagSet tagSet) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, serverDescription -> (serverDescription.isPrimary() || serverDescription.isSecondary()) && serverDescription.hasTags(tagSet));
    }

    public static List<ServerDescription> getServersByPredicate(ClusterDescription clusterDescription, Predicate predicate) {
        ArrayList<ServerDescription> membersByTag = new ArrayList<ServerDescription>();
        for (ServerDescription cur : clusterDescription.getServerDescriptions()) {
            if (!predicate.apply(cur)) continue;
            membersByTag.add(cur);
        }
        return membersByTag;
    }

    private ClusterDescriptionHelper() {
    }

    public static interface Predicate {
        public boolean apply(ServerDescription var1);
    }
}

