/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.docker;

import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerPort;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.types.HttpLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DockerService {
    private final String name;
    private final String host;
    private String containerId;
    private List<String> containerNames;
    private List<Record> records = new ArrayList<Record>();

    public DockerService(Container container, String host) {
        this.host = host;
        this.containerId = container.getId();
        this.containerNames = Arrays.stream(container.getNames()).collect(Collectors.toList());
        this.name = !this.containerNames.isEmpty() ? this.containerNames.get(0) : this.containerId;
        for (ContainerPort port : container.getPorts()) {
            Record record = this.createRecord(container, port);
            if (record == null) continue;
            this.records.add(record);
        }
    }

    public List<Record> records() {
        return this.records;
    }

    public String name() {
        return this.name;
    }

    public List<String> names() {
        return this.containerNames;
    }

    public String id() {
        return this.containerId;
    }

    public Record createRecord(Container container, ContainerPort port) {
        String type;
        Record record = new Record().setName(this.name);
        Map labels = container.getLabels();
        if (labels != null) {
            for (Map.Entry entry : labels.entrySet()) {
                record.getMetadata().put((String)entry.getKey(), entry.getValue());
            }
        }
        JsonArray names = new JsonArray();
        this.containerNames.forEach(arg_0 -> ((JsonArray)names).add(arg_0));
        record.getMetadata().put("docker.names", (Object)names);
        record.getMetadata().put("docker.name", (Object)this.name);
        record.getMetadata().put("docker.id", (Object)this.containerId);
        String string = type = labels != null ? (String)labels.get("service.type") : "unknown";
        if (type == null) {
            type = "unknown";
        }
        switch (type) {
            case "http-endpoint": {
                return DockerService.manageHttpService(record, port, labels);
            }
        }
        return this.manageUnknownService(record, port);
    }

    private Record manageUnknownService(Record record, ContainerPort port) {
        if (port.getPublicPort() == null || port.getPublicPort() == 0) {
            return null;
        }
        JsonObject location = new JsonObject();
        location.put("port", (Object)port.getPublicPort());
        location.put("internal-port", (Object)port.getPrivatePort());
        location.put("type", (Object)port.getType());
        location.put("ip", (Object)this.host);
        return record.setLocation(location).setType("unknown");
    }

    private static Record manageHttpService(Record record, ContainerPort port, Map<String, String> labels) {
        if (port.getPublicPort() == null || port.getPublicPort() == 0) {
            return null;
        }
        record.setType("http-endpoint");
        HttpLocation location = new HttpLocation().setHost(port.getIp()).setPort(port.getPublicPort().intValue());
        if (DockerService.isTrue(labels, "ssl") || port.getPrivatePort() == 443) {
            location.setSsl(true);
        }
        return record.setLocation(location.toJson());
    }

    private static boolean isTrue(Map<String, String> labels, String key) {
        return labels != null && "true".equalsIgnoreCase(labels.get(key));
    }
}

