/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.spi;

import io.vertx.core.Closeable;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Pool;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.db2client.impl.DB2ConnectionUriParser;
import io.vertx.db2client.impl.DB2PoolImpl;
import io.vertx.db2client.impl.Db2PoolOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolImpl;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.List;
import java.util.stream.Collectors;

public class DB2Driver
implements Driver {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.db2client";
    public static final DB2Driver INSTANCE = new DB2Driver();

    public DB2Pool newPool(Vertx vertx, List<? extends SqlConnectOptions> databases, PoolOptions options, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = options.isShared() ? (PoolImpl)vx.createSharedClient(SHARED_CLIENT_KEY, options.getName(), closeFuture, cf -> this.newPoolImpl(vx, databases, options, (CloseFuture)cf)) : this.newPoolImpl(vx, databases, options, closeFuture);
        return new DB2PoolImpl(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, List<? extends SqlConnectOptions> databases, PoolOptions options, CloseFuture closeFuture) {
        DB2ConnectOptions baseConnectOptions = DB2ConnectOptions.wrap(databases.get(0));
        QueryTracer tracer = vertx.tracer() == null ? null : new QueryTracer(vertx.tracer(), (SqlConnectOptions)baseConnectOptions);
        VertxMetrics vertxMetrics = vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(baseConnectOptions.getSocketAddress(), "sql", baseConnectOptions.getMetricsName()) : null;
        boolean pipelinedPool = options instanceof Db2PoolOptions && ((Db2PoolOptions)options).isPipelined();
        int pipeliningLimit = pipelinedPool ? baseConnectOptions.getPipeliningLimit() : 1;
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, tracer, metrics, pipeliningLimit, options, null, null, closeFuture);
        List lst = databases.stream().map(o -> this.createConnectionFactory((Vertx)vertx, (SqlConnectOptions)o)).collect(Collectors.toList());
        ConnectionFactory factory = ConnectionFactory.roundRobinSelector(lst);
        pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
        pool.init();
        closeFuture.add((Closeable)factory);
        return pool;
    }

    public DB2ConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = DB2ConnectionUriParser.parse(uri, false);
        return conf == null ? null : new DB2ConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof DB2ConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, SqlConnectOptions database) {
        return new DB2ConnectionFactory((VertxInternal)vertx, DB2ConnectOptions.wrap(database));
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        return new DB2ConnectionImpl(context, factory, conn, tracer, metrics);
    }
}

