/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.OperationResponseConverter;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
@Deprecated
public class OperationResponse {
    private static final Integer DEFAULT_STATUS_CODE = 200;
    private Integer statusCode;
    private String statusMessage;
    private Buffer payload;
    private MultiMap headers;

    public OperationResponse() {
        this.init();
    }

    public OperationResponse(JsonObject json) {
        this.init();
        OperationResponseConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        JsonObject hdrs = json.getJsonObject("headers", null);
        if (hdrs != null) {
            this.headers = HttpHeaders.headers();
            for (Map.Entry entry : hdrs) {
                if (!(entry.getValue() instanceof String)) {
                    throw new IllegalStateException("Invalid type for message header value " + entry.getValue().getClass());
                }
                this.headers.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public OperationResponse(Integer statusCode, String statusMessage, Buffer payload, MultiMap headers) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.payload = payload;
        this.headers = headers;
    }

    public OperationResponse(OperationResponse other) {
        this.statusCode = other.getStatusCode();
        this.statusMessage = other.getStatusMessage();
        this.payload = other.getPayload();
        this.headers = other.getHeaders();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OperationResponseConverter.toJson(this, json);
        if (this.headers != null) {
            JsonObject hJson = new JsonObject();
            this.headers.entries().forEach(entry -> hJson.put((String)entry.getKey(), entry.getValue()));
            json.put("headers", (Object)hJson);
        }
        return json;
    }

    private void init() {
        this.statusCode = DEFAULT_STATUS_CODE;
        this.payload = null;
        this.headers = MultiMap.caseInsensitiveMultiMap();
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Buffer getPayload() {
        return this.payload;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    @Fluent
    public OperationResponse setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @Fluent
    public OperationResponse setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Fluent
    public OperationResponse setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    @Fluent
    public OperationResponse setPayload(Buffer payload) {
        this.payload = payload;
        return this;
    }

    @Fluent
    public OperationResponse putHeader(String key, String value) {
        this.headers.add(key, value);
        return this;
    }

    public static OperationResponse completedWithJson(JsonObject jsonObject) {
        return OperationResponse.completedWithJson(jsonObject.toBuffer());
    }

    public static OperationResponse completedWithJson(JsonArray jsonArray) {
        return OperationResponse.completedWithJson(jsonArray.toBuffer());
    }

    public static OperationResponse completedWithJson(Buffer json) {
        OperationResponse op = new OperationResponse();
        op.setStatusCode(200);
        op.setStatusMessage("OK");
        op.putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/json");
        op.setPayload(json);
        return op;
    }

    public static OperationResponse completedWithPlainText(Buffer text) {
        return new OperationResponse().setStatusCode(200).setStatusMessage("OK").putHeader(HttpHeaders.CONTENT_TYPE.toString(), "text/plain").setPayload(text);
    }
}

