/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.commands.AbstractCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import oracle.jdbc.OracleConnection;

public class OracleTransactionCommand<R>
extends AbstractCommand<R> {
    private final TxCommand<R> op;

    public OracleTransactionCommand(TxCommand<R> op) {
        this.op = op;
    }

    @Override
    public Future<R> execute(OracleConnection conn, ContextInternal context) {
        Future<Void> result = this.op.kind == TxCommand.Kind.BEGIN ? this.begin(conn, context) : (this.op.kind == TxCommand.Kind.COMMIT ? this.commit(conn, context) : this.rollback(conn, context));
        return result.map(this.op.result);
    }

    private Future<Void> begin(OracleConnection conn, ContextInternal context) {
        return Helper.executeBlocking((Context)context, () -> {
            int isolation = conn.getTransactionIsolation();
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(isolation);
        });
    }

    private Future<Void> commit(OracleConnection conn, ContextInternal context) {
        return Helper.executeBlocking((Context)context, () -> conn.getAutoCommit()).compose(autoCommit -> autoCommit != false ? Future.succeededFuture() : Helper.first(conn.commitAsyncOracle(), context)).eventually(v -> Helper.executeBlocking((Context)context, () -> conn.setAutoCommit(true)));
    }

    private Future<Void> rollback(OracleConnection conn, ContextInternal context) {
        return Helper.executeBlocking((Context)context, () -> conn.getAutoCommit()).compose(autoCommit -> autoCommit != false ? Future.succeededFuture() : Helper.first(conn.rollbackAsyncOracle(), context)).eventually(v -> Helper.executeBlocking((Context)context, () -> conn.setAutoCommit(true)));
    }
}

