/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.datatype.DataType;
import io.vertx.mysqlclient.impl.protocol.ColumnDefinition;
import io.vertx.mysqlclient.impl.protocol.Packets;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

abstract class CommandCodec<R, C extends CommandBase<R>> {
    public Throwable failure;
    public R result;
    final C cmd;
    MySQLEncoder encoder;
    int sequenceId;

    CommandCodec(C cmd) {
        this.cmd = cmd;
    }

    abstract void decodePayload(ByteBuf var1, int var2);

    void encode(MySQLEncoder encoder) {
        this.encoder = encoder;
        this.sequenceId = 0;
    }

    ByteBuf allocateBuffer() {
        return this.encoder.chctx.alloc().ioBuffer();
    }

    ByteBuf allocateBuffer(int capacity) {
        return this.encoder.chctx.alloc().ioBuffer(capacity);
    }

    void sendPacket(ByteBuf packet, int payloadLength) {
        if (payloadLength >= 0xFFFFFF) {
            this.sendSplitPacket(packet);
        } else {
            this.sendNonSplitPacket(packet);
        }
    }

    private void sendSplitPacket(ByteBuf packet) {
        ByteBuf packetHeader;
        ByteBuf payload = packet.skipBytes(4);
        while (payload.readableBytes() >= 0xFFFFFF) {
            packetHeader = this.allocateBuffer(4);
            packetHeader.writeMediumLE(0xFFFFFF);
            packetHeader.writeByte(this.sequenceId++);
            this.encoder.chctx.write((Object)packetHeader, this.encoder.chctx.voidPromise());
            this.encoder.chctx.write((Object)payload.readRetainedSlice(0xFFFFFF), this.encoder.chctx.voidPromise());
        }
        packetHeader = this.allocateBuffer(4);
        packetHeader.writeMediumLE(payload.readableBytes());
        packetHeader.writeByte(this.sequenceId++);
        this.encoder.chctx.write((Object)packetHeader, this.encoder.chctx.voidPromise());
        this.encoder.chctx.writeAndFlush((Object)payload, this.encoder.chctx.voidPromise());
    }

    void sendNonSplitPacket(ByteBuf packet) {
        ++this.sequenceId;
        this.encoder.chctx.writeAndFlush((Object)packet, this.encoder.chctx.voidPromise());
    }

    final void sendBytesAsPacket(byte[] payload) {
        int payloadLength = payload.length;
        ByteBuf packet = this.allocateBuffer(payloadLength + 4);
        packet.writeMediumLE(payloadLength);
        packet.writeByte(this.sequenceId);
        packet.writeBytes(payload);
        this.sendNonSplitPacket(packet);
    }

    void handleOkPacketOrErrorPacketPayload(ByteBuf payload) {
        short header = payload.getUnsignedByte(payload.readerIndex());
        switch (header) {
            case 0: 
            case 254: {
                this.encoder.handleCommandResponse(CommandResponse.success(null));
                break;
            }
            case 255: {
                this.handleErrorPacketPayload(payload);
            }
        }
    }

    void handleErrorPacketPayload(ByteBuf payload) {
        MySQLException mySQLException = this.decodeErrorPacketPayload(payload);
        this.encoder.handleCommandResponse(CommandResponse.failure((Throwable)mySQLException));
    }

    final MySQLException decodeErrorPacketPayload(ByteBuf payload) {
        payload.skipBytes(1);
        int errorCode = payload.readUnsignedShortLE();
        payload.skipBytes(1);
        String sqlState = BufferUtils.readFixedLengthString(payload, 5, StandardCharsets.UTF_8);
        String errorMessage = this.readRestOfPacketString(payload, StandardCharsets.UTF_8);
        return new MySQLException(errorMessage, errorCode, sqlState);
    }

    Packets.OkPacket decodeOkPacketPayload(ByteBuf payload) {
        payload.skipBytes(1);
        int affectedRows = (int)BufferUtils.readLengthEncodedInteger(payload);
        long lastInsertId = BufferUtils.readLengthEncodedInteger(payload);
        int serverStatusFlags = payload.readUnsignedShortLE();
        return new Packets.OkPacket(affectedRows, lastInsertId, serverStatusFlags);
    }

    Packets.EofPacket decodeEofPacketPayload(ByteBuf payload) {
        payload.skipBytes(1);
        int numberOfWarnings = payload.readUnsignedShortLE();
        int serverStatusFlags = payload.readUnsignedShortLE();
        return new Packets.EofPacket(numberOfWarnings, serverStatusFlags);
    }

    String readRestOfPacketString(ByteBuf payload, Charset charset) {
        return BufferUtils.readFixedLengthString(payload, payload.readableBytes(), charset);
    }

    ColumnDefinition decodeColumnDefinitionPacketPayload(ByteBuf payload) {
        int start = payload.readerIndex();
        int bytesToSkip = 0;
        bytesToSkip = (int)((long)bytesToSkip + BufferUtils.countBytesOfLengthEncodedString(payload, start + bytesToSkip));
        bytesToSkip = (int)((long)bytesToSkip + BufferUtils.countBytesOfLengthEncodedString(payload, start + bytesToSkip));
        bytesToSkip = (int)((long)bytesToSkip + BufferUtils.countBytesOfLengthEncodedString(payload, start + bytesToSkip));
        bytesToSkip = (int)((long)bytesToSkip + BufferUtils.countBytesOfLengthEncodedString(payload, start + bytesToSkip));
        payload.skipBytes(bytesToSkip);
        String name = BufferUtils.readLengthEncodedString(payload, StandardCharsets.UTF_8);
        start = payload.readerIndex();
        bytesToSkip = 0;
        bytesToSkip = (int)((long)bytesToSkip + BufferUtils.countBytesOfLengthEncodedString(payload, start + bytesToSkip));
        bytesToSkip = (int)((long)bytesToSkip + BufferUtils.countBytesOfLengthEncodedInteger(payload, start + bytesToSkip));
        int characterSet = payload.getUnsignedShortLE(start + bytesToSkip);
        DataType type = DataType.valueOf(payload.getUnsignedByte(start + (bytesToSkip += 6)));
        int flags = payload.getUnsignedShortLE(start + ++bytesToSkip);
        payload.skipBytes(bytesToSkip += 2);
        return new ColumnDefinition(name, characterSet, type, flags);
    }

    void skipEofPacketIfNeeded(ByteBuf payload) {
        if (!this.isDeprecatingEofFlagEnabled()) {
            payload.skipBytes(5);
        }
    }

    boolean isDeprecatingEofFlagEnabled() {
        return (this.encoder.clientCapabilitiesFlag & 0x1000000) != 0;
    }

    boolean expectNoResponsePacket() {
        return false;
    }
}

