/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.vertx.mysqlclient.impl.MySQLSocketConnection;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLDecoder;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class MySQLCodec
extends CombinedChannelDuplexHandler<MySQLDecoder, MySQLEncoder> {
    ArrayDeque<CommandCodec<?, ?>> inflight = new ArrayDeque();

    public MySQLCodec(MySQLSocketConnection mySQLSocketConnection) {
        MySQLEncoder encoder = new MySQLEncoder(this.inflight, mySQLSocketConnection);
        MySQLDecoder decoder = new MySQLDecoder(this.inflight);
        this.init((ChannelInboundHandler)decoder, (ChannelOutboundHandler)encoder);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.clearInflightCommands(ctx, "Fail to read any response from the server, the underlying connection might get lost unexpectedly.");
        super.channelInactive(ctx);
    }

    private void clearInflightCommands(ChannelHandlerContext ctx, String failureMsg) {
        Iterator<CommandCodec<?, ?>> it = this.inflight.iterator();
        while (it.hasNext()) {
            CommandCodec<?, ?> codec = it.next();
            it.remove();
            CommandResponse failure = CommandResponse.failure((String)failureMsg);
            failure.cmd = codec.cmd;
            ctx.fireChannelRead((Object)failure);
        }
    }

    static void checkFireAndForgetCommands(Deque<CommandCodec<?, ?>> inflight) {
        CommandCodec<?, ?> commandCodec;
        while ((commandCodec = inflight.peek()) != null && commandCodec.expectNoResponsePacket()) {
            commandCodec.decodePayload(null, 0);
        }
    }
}

