/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import io.vertx.mssqlclient.impl.codec.Encoding;
import io.vertx.mssqlclient.impl.codec.TypeInfo;
import io.vertx.mssqlclient.impl.utils.ByteBufUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public enum DataType {
    NULL(31){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public String paramDefinition(Object value) {
            return "nvarchar(4000)";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
        }
    }
    ,
    INT1(48){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.TINYINT;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return byteBuf.readUnsignedByte();
        }
    }
    ,
    BIT(50){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.BOOLEAN;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return byteBuf.readBoolean();
        }
    }
    ,
    INT2(52){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.SMALLINT;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return byteBuf.readShortLE();
        }
    }
    ,
    INT4(56){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.INTEGER;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return byteBuf.readIntLE();
        }
    }
    ,
    DATETIM4(58){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.TIMESTAMP;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return DataType.decodeUnsignedShortDateValue(byteBuf);
        }

        @Override
        public String paramDefinition(Object value) {
            return "smalldatetime";
        }
    }
    ,
    FLT4(59){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.REAL;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return Float.valueOf(byteBuf.readFloatLE());
        }
    }
    ,
    MONEY(60){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            long highBits = (long)byteBuf.readIntLE() << 32;
            long lowBits = (long)byteBuf.readIntLE() & 0xFFFFFFFFL;
            BigInteger bigInteger = BigInteger.valueOf(highBits | lowBits);
            return new BigDecimal(bigInteger).divide(new BigDecimal("10000"), 4, RoundingMode.UP);
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.DECIMAL;
        }
    }
    ,
    DATETIME(61){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.TIMESTAMP;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return DataType.decodeIntLEDateValue(byteBuf);
        }
    }
    ,
    FLT8(62){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.DOUBLE;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return byteBuf.readDoubleLE();
        }
    }
    ,
    MONEY4(122){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return new BigDecimal(byteBuf.readIntLE()).divide(new BigDecimal("10000"), 2, RoundingMode.UP);
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.DECIMAL;
        }
    }
    ,
    INT8(127){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.BIGINT;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return byteBuf.readLongLE();
        }
    }
    ,
    DECIMAL(55),
    NUMERIC(63),
    GUID(36){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            if (typeInfo.maxLength() == 16) {
                return JDBCType.OTHER;
            }
            throw new IllegalArgumentException("Invalid length: " + typeInfo.maxLength());
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 16) {
                long first = byteBuf.readIntLE();
                long second = byteBuf.readShortLE() & 0xFFFF;
                long third = byteBuf.readShortLE() & 0xFFFF;
                long lsb = byteBuf.readLong();
                return new UUID((first << 32) + (second << 16) + third, lsb);
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "uniqueidentifier";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            if (!(value instanceof UUID)) {
                throw new IllegalArgumentException(value.getClass().getName());
            }
            UUID uValue = (UUID)value;
            DataType.writeParamSize(byteBuf, 16, 16);
            long msb = uValue.getMostSignificantBits();
            byteBuf.writeIntLE((int)(msb >> 32));
            byteBuf.writeShortLE((int)((short)(msb >> 16)));
            byteBuf.writeShortLE((int)((short)msb));
            byteBuf.writeLong(uValue.getLeastSignificantBits());
        }
    }
    ,
    INTN(38){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            if (typeInfo.maxLength() == 1) {
                return JDBCType.TINYINT;
            }
            if (typeInfo.maxLength() == 2) {
                return JDBCType.SMALLINT;
            }
            if (typeInfo.maxLength() == 4) {
                return JDBCType.INTEGER;
            }
            if (typeInfo.maxLength() == 8) {
                return JDBCType.BIGINT;
            }
            throw new IllegalArgumentException("Invalid length: " + typeInfo.maxLength());
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 1) {
                return byteBuf.readUnsignedByte();
            }
            if (length == 2) {
                return byteBuf.readShortLE();
            }
            if (length == 4) {
                return byteBuf.readIntLE();
            }
            if (length == 8) {
                return byteBuf.readLongLE();
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "bigint";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            if (value instanceof Byte) {
                Byte bValue = (Byte)value;
                DataType.writeParamSize(byteBuf, 1, 1);
                byteBuf.writeByte((int)bValue.byteValue());
            } else if (value instanceof Short) {
                Short sValue = (Short)value;
                DataType.writeParamSize(byteBuf, 2, 2);
                byteBuf.writeShortLE((int)sValue.shortValue());
            } else if (value instanceof Integer) {
                Integer iValue = (Integer)value;
                DataType.writeParamSize(byteBuf, 4, 4);
                byteBuf.writeIntLE(iValue.intValue());
            } else if (value instanceof Long) {
                Long lValue = (Long)value;
                DataType.writeParamSize(byteBuf, 8, 8);
                byteBuf.writeLongLE(lValue.longValue());
            } else {
                throw new IllegalArgumentException(value.getClass().getName());
            }
        }
    }
    ,
    BITN(104){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.BOOLEAN;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 1) {
                return byteBuf.readBoolean();
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "bit";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, 15.BITN.id);
            DataType.writeParamSize(byteBuf, 1, 1);
            byteBuf.writeBoolean(((Boolean)value).booleanValue());
        }
    }
    ,
    DECIMALN(106){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readUnsignedByte()).precision(byteBuf.readByte()).scale(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.DECIMAL;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            short length = byteBuf.readUnsignedByte();
            if (length == 0) {
                return null;
            }
            byte sign = byteBuf.readByte();
            byte[] bytes = new byte[length - 1];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = byteBuf.getByte(byteBuf.readerIndex() + bytes.length - 1 - i);
            }
            byteBuf.skipBytes(bytes.length);
            BigInteger bigInteger = new BigInteger(0 == sign ? -1 : 1, bytes);
            BigDecimal bigDecimal = new BigDecimal(bigInteger, typeInfo.scale());
            return bigDecimal;
        }

        @Override
        public String paramDefinition(Object value) {
            return "numeric(38," + (value == null ? 0 : Math.max(0, ((BigDecimal)value).scale())) + ")";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            BigDecimal bigDecimal = (BigDecimal)value;
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            DataType.writeParamSize(byteBuf, 17, 38);
            int sign = bigDecimal.signum() < 0 ? 0 : 1;
            byte[] bytes = (sign == 0 ? bigDecimal.negate() : bigDecimal).unscaledValue().toByteArray();
            byteBuf.writeByte(Math.max(0, bigDecimal.scale()));
            byteBuf.writeByte(1 + bytes.length);
            byteBuf.writeByte(sign);
            for (int i = bytes.length - 1; i >= 0; --i) {
                byteBuf.writeByte((int)bytes[i]);
            }
        }
    }
    ,
    NUMERICN(108){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return DECIMALN.decodeTypeInfo(byteBuf);
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.DECIMAL;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return DECIMALN.decodeValue(byteBuf, typeInfo);
        }
    }
    ,
    FLTN(109){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            if (typeInfo.maxLength() == 4) {
                return JDBCType.REAL;
            }
            if (typeInfo.maxLength() == 8) {
                return JDBCType.DOUBLE;
            }
            throw new IllegalArgumentException("Invalid length: " + typeInfo.maxLength());
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 4) {
                return Float.valueOf(byteBuf.readFloatLE());
            }
            if (length == 8) {
                return byteBuf.readDoubleLE();
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "float";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            if (value instanceof Float) {
                Float fValue = (Float)value;
                DataType.writeParamSize(byteBuf, 4, 4);
                byteBuf.writeFloatLE(fValue.floatValue());
            } else if (value instanceof Double) {
                Double dValue = (Double)value;
                DataType.writeParamSize(byteBuf, 8, 8);
                byteBuf.writeDoubleLE(dValue.doubleValue());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }
    ,
    MONEYN(110){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().scale(byteBuf.readByte());
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 4) {
                return MONEY4.decodeValue(byteBuf, typeInfo);
            }
            if (length == 8) {
                return MONEY.decodeValue(byteBuf, typeInfo);
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.DECIMAL;
        }
    }
    ,
    DATETIMN(111){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().scale(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.TIMESTAMP;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 8) {
                return DataType.decodeIntLEDateValue(byteBuf);
            }
            if (length == 4) {
                return DataType.decodeUnsignedShortDateValue(byteBuf);
            }
            throw new UnsupportedOperationException("Invalid length for date " + this.name());
        }

        @Override
        public String paramDefinition(Object value) {
            return "datetime";
        }
    }
    ,
    DATEN(40){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.DATE;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            return DataType.decodeLocalDate(byteBuf, length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "date";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            byteBuf.writeByte(3);
            byteBuf.writeMediumLE(DataType.daysFromStartDate((LocalDate)value));
        }
    }
    ,
    TIMEN(41){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().scale(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.TIME;
        }

        @Override
        public String paramDefinition(Object value) {
            return "time";
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            return DataType.decodeLocalTime(byteBuf, length, typeInfo.scale());
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            DataType.writeParamSize(byteBuf, 7, 5);
            ByteBufUtils.writeUnsignedInt40LE(byteBuf, DataType.hundredsOfNanos((LocalTime)value));
        }
    }
    ,
    DATETIME2N(42){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().scale(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.TIMESTAMP;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            LocalTime localTime = DataType.decodeLocalTime(byteBuf, length - 3, typeInfo.scale());
            LocalDate localDate = DataType.decodeLocalDate(byteBuf, 3);
            return LocalDateTime.of(localDate, localTime);
        }

        @Override
        public String paramDefinition(Object value) {
            return "datetime2";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            DataType.writeParamSize(byteBuf, 7, 8);
            ByteBufUtils.writeUnsignedInt40LE(byteBuf, DataType.hundredsOfNanos(localDateTime.toLocalTime()));
            byteBuf.writeMediumLE(DataType.daysFromStartDate(localDateTime.toLocalDate()));
        }
    }
    ,
    DATETIMEOFFSETN(43){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().scale(byteBuf.readByte());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.TIMESTAMP_WITH_TIMEZONE;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            LocalTime localTime = DataType.decodeLocalTime(byteBuf, length - 5, typeInfo.scale());
            LocalDate localDate = DataType.decodeLocalDate(byteBuf, 3);
            short minutes = byteBuf.readShortLE();
            return LocalDateTime.of(localDate, localTime).plusMinutes(minutes).atOffset(ZoneOffset.ofTotalSeconds(60 * minutes));
        }

        @Override
        public String paramDefinition(Object value) {
            return "datetimeoffset";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            DataType.writeParamSize(byteBuf, 7, 10);
            int offsetMinutes = offsetDateTime.getOffset().getTotalSeconds() / 60;
            LocalDateTime localDateTime = offsetDateTime.toLocalDateTime().minusMinutes(offsetMinutes);
            ByteBufUtils.writeUnsignedInt40LE(byteBuf, DataType.hundredsOfNanos(localDateTime.toLocalTime()));
            byteBuf.writeMediumLE(DataType.daysFromStartDate(localDateTime.toLocalDate()));
            byteBuf.writeShortLE(offsetMinutes);
        }
    }
    ,
    CHAR(47),
    VARCHAR(39),
    BINARY(45){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readUnsignedShortLE());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.BINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return BIGVARBINARY.decodeValue(byteBuf, typeInfo);
        }
    }
    ,
    VARBINARY(37){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readUnsignedShortLE());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.VARBINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return BIGVARBINARY.decodeValue(byteBuf, typeInfo);
        }
    }
    ,
    BIGVARBINARY(165){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readUnsignedShortLE());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.LONGVARBINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            int length;
            long payloadLength;
            Buffer result = DataType.isPLP(typeInfo) ? (DataType.isPLPNull(payloadLength = byteBuf.readLongLE()) ? null : Buffer.buffer((ByteBuf)DataType.readPLP(byteBuf))) : ((length = byteBuf.readUnsignedShortLE()) == 65535 ? null : DataType.decodeBinaryValue(byteBuf, length));
            return result;
        }

        @Override
        public String paramDefinition(Object value) {
            String definition = value == null ? "binary(1)" : (((Buffer)value).length() > 8000 ? "varbinary(max)" : "varbinary(8000)");
            return definition;
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            Buffer buffer = (Buffer)value;
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            if (buffer.length() > 8000) {
                byteBuf.writeShortLE(65535);
                byteBuf.writeLongLE((long)buffer.length());
                byteBuf.writeIntLE(buffer.length());
                byteBuf.writeBytes(buffer.getByteBuf());
                byteBuf.writeIntLE(0);
            } else {
                byteBuf.writeShortLE(buffer.length());
                byteBuf.writeShortLE(buffer.length());
                byteBuf.writeBytes(buffer.getByteBuf());
            }
        }
    }
    ,
    BIGVARCHAR(167){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            TypeInfo typeInfo = new TypeInfo().maxLength(byteBuf.readUnsignedShortLE());
            DataType.decodeCharacterMetadata(typeInfo, byteBuf, null);
            return typeInfo;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.VARCHAR;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return NVARCHAR.decodeValue(byteBuf, typeInfo);
        }
    }
    ,
    BIGBINARY(173){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            return new TypeInfo().maxLength(byteBuf.readUnsignedShortLE());
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.BINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return BIGVARBINARY.decodeValue(byteBuf, typeInfo);
        }
    }
    ,
    BIGCHAR(175){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            TypeInfo typeInfo = new TypeInfo().maxLength(byteBuf.readUnsignedShortLE());
            DataType.decodeCharacterMetadata(typeInfo, byteBuf, null);
            return typeInfo;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.CHAR;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return BIGVARCHAR.decodeValue(byteBuf, typeInfo);
        }
    }
    ,
    NVARCHAR(231){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            TypeInfo typeInfo = new TypeInfo().maxLength(byteBuf.readUnsignedShortLE());
            DataType.decodeCharacterMetadata(typeInfo, byteBuf, StandardCharsets.UTF_16LE);
            return typeInfo;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.VARCHAR;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            int length;
            long payloadLength;
            CharSequence result = DataType.isPLP(typeInfo) ? (DataType.isPLPNull(payloadLength = byteBuf.readLongLE()) ? null : DataType.readPLP(byteBuf).toString(typeInfo.charset())) : ((length = byteBuf.readUnsignedShortLE()) == 65535 ? null : byteBuf.readCharSequence(length, typeInfo.charset()));
            return result;
        }

        @Override
        public String paramDefinition(Object value) {
            String val = this.stringRepresentation(value);
            return val != null && val.length() > 4000 ? "nvarchar(max)" : "nvarchar(4000)";
        }

        private String stringRepresentation(Object value) {
            return value == null ? null : (value.getClass().isEnum() ? ((Enum)value).name() : value.toString());
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            String val = this.stringRepresentation(value);
            if (val.length() > 4000) {
                byteBuf.writeShortLE(65535);
                this.writeCollation(byteBuf);
                byteBuf.writeLongLE((long)val.length() * 2L);
                byteBuf.writeIntLE(val.length() * 2);
                byteBuf.writeCharSequence((CharSequence)val, StandardCharsets.UTF_16LE);
                byteBuf.writeIntLE(0);
            } else {
                byteBuf.writeShortLE(8000);
                this.writeCollation(byteBuf);
                byteBuf.writeShortLE(val.length() * 2);
                byteBuf.writeCharSequence((CharSequence)val, StandardCharsets.UTF_16LE);
            }
        }

        private void writeCollation(ByteBuf byteBuf) {
            byteBuf.writeInt(151310336);
            byteBuf.writeByte(52);
        }
    }
    ,
    NCHAR(239){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            TypeInfo typeInfo = new TypeInfo().maxLength(byteBuf.readUnsignedShortLE());
            DataType.decodeCharacterMetadata(typeInfo, byteBuf, StandardCharsets.UTF_16LE);
            return typeInfo;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.CHAR;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return NVARCHAR.decodeValue(byteBuf, typeInfo);
        }
    }
    ,
    XML(241),
    UDT(240),
    TEXT(35){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            TypeInfo typeInfo = new TypeInfo().maxLength(byteBuf.readIntLE());
            DataType.decodeCharacterMetadata(typeInfo, byteBuf, null);
            DataType.skipMultipartTableName(byteBuf);
            return typeInfo;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.LONGVARCHAR;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            return NTEXT.decodeValue(byteBuf, typeInfo);
        }
    }
    ,
    IMAGE(34){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            TypeInfo typeInfo = new TypeInfo().maxLength(byteBuf.readIntLE());
            DataType.skipMultipartTableName(byteBuf);
            return typeInfo;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.LONGVARBINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            Buffer result;
            if (byteBuf.readUnsignedByte() == 0) {
                result = null;
            } else {
                byteBuf.skipBytes(24);
                int length = byteBuf.readIntLE();
                result = DataType.decodeBinaryValue(byteBuf, length);
            }
            return result;
        }
    }
    ,
    NTEXT(99){

        @Override
        public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
            TypeInfo typeInfo = new TypeInfo().maxLength(byteBuf.readIntLE());
            DataType.decodeCharacterMetadata(typeInfo, byteBuf, StandardCharsets.UTF_16LE);
            DataType.skipMultipartTableName(byteBuf);
            return typeInfo;
        }

        @Override
        public JDBCType jdbcType(TypeInfo typeInfo) {
            return JDBCType.LONGVARCHAR;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
            CharSequence result;
            if (byteBuf.readUnsignedByte() == 0) {
                result = null;
            } else {
                byteBuf.skipBytes(24);
                int length = byteBuf.readIntLE();
                result = byteBuf.readCharSequence(length, typeInfo.charset());
            }
            return result;
        }
    }
    ,
    SSVARIANT(98);

    public final int id;
    private static final LocalDate START_DATE;
    private static final LocalDate START_DATE_DATETIME;
    private static final IntObjectMap<DataType> typesById;
    private static final Map<Class<?>, DataType> typesByValueClass;

    private DataType(int id) {
        this.id = id;
    }

    private static void skipMultipartTableName(ByteBuf byteBuf) {
        int numParts = byteBuf.readUnsignedByte();
        for (int i = 0; i < numParts; ++i) {
            byteBuf.skipBytes(2 * byteBuf.readUnsignedShortLE());
        }
    }

    private static void decodeCharacterMetadata(TypeInfo typeInfo, ByteBuf byteBuf, Charset charset) {
        if (charset != null) {
            typeInfo.charset(charset);
            byteBuf.skipBytes(5);
        } else {
            typeInfo.charset(Encoding.readCharsetFrom(byteBuf));
        }
    }

    private static boolean isPLP(TypeInfo typeInfo) {
        return typeInfo.maxLength() == 65535;
    }

    private static boolean isPLPNull(long payloadLength) {
        return payloadLength == -1L;
    }

    private static ByteBuf readPLP(ByteBuf byteBuf) {
        int startIndex;
        int nextIndex = startIndex = byteBuf.readerIndex();
        int totalSize = 0;
        int chunkSize = (int)byteBuf.getUnsignedIntLE(nextIndex);
        while (chunkSize > 0) {
            totalSize += chunkSize;
            chunkSize = (int)byteBuf.getUnsignedIntLE(nextIndex += 4 + chunkSize);
        }
        ByteBuf heapBuffer = VertxByteBufAllocator.DEFAULT.heapBuffer(totalSize);
        nextIndex = startIndex;
        int chunkSize2 = (int)byteBuf.getUnsignedIntLE(nextIndex);
        while (chunkSize2 > 0) {
            heapBuffer.writeBytes(byteBuf, nextIndex + 4, chunkSize2);
            chunkSize2 = (int)byteBuf.getUnsignedIntLE(nextIndex += 4 + chunkSize2);
        }
        byteBuf.readerIndex(nextIndex + 4);
        return heapBuffer;
    }

    private static Buffer decodeBinaryValue(ByteBuf byteBuf, int length) {
        ByteBuf unpooled = Unpooled.buffer((int)length);
        byteBuf.readBytes(unpooled, 0, length);
        unpooled.writerIndex(length);
        return Buffer.buffer((ByteBuf)unpooled);
    }

    private static LocalDateTime decodeIntLEDateValue(ByteBuf byteBuf) {
        LocalDate localDate = START_DATE_DATETIME.plus(byteBuf.readIntLE(), ChronoUnit.DAYS);
        long nanoOfDay = TimeUnit.NANOSECONDS.convert(Math.round((double)byteBuf.readIntLE() * 3.3333333333333335), TimeUnit.MILLISECONDS);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    private static LocalDateTime decodeUnsignedShortDateValue(ByteBuf byteBuf) {
        LocalDate localDate = START_DATE_DATETIME.plus(byteBuf.readUnsignedShortLE(), ChronoUnit.DAYS);
        LocalTime localTime = LocalTime.ofSecondOfDay((long)byteBuf.readUnsignedShortLE() * 60L);
        return LocalDateTime.of(localDate, localTime);
    }

    public TypeInfo decodeTypeInfo(ByteBuf byteBuf) {
        throw new UnsupportedOperationException("Unable to decode typeInfo for " + this.name());
    }

    public JDBCType jdbcType(TypeInfo typeInfo) {
        throw new UnsupportedOperationException("Unable to determine jdbc type for " + this.name());
    }

    public Object decodeValue(ByteBuf byteBuf, TypeInfo typeInfo) {
        throw new UnsupportedOperationException("Unable to decode value for " + this.name());
    }

    public String paramDefinition(Object value) {
        throw new UnsupportedOperationException("Unable to generate param definition for " + this.name());
    }

    public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
        throw new UnsupportedOperationException("Unable to encode param for " + this.name());
    }

    public static DataType forId(int id) {
        DataType dataType = (DataType)((Object)typesById.get(id));
        if (dataType == null) {
            throw new IllegalArgumentException("Unknown data type: " + id);
        }
        return dataType;
    }

    public static DataType forValueClass(Class<?> valueClass) {
        DataType dataType = Buffer.class.isAssignableFrom(valueClass) ? typesByValueClass.get(Buffer.class) : (valueClass.isEnum() ? typesByValueClass.get(String.class) : typesByValueClass.get(valueClass));
        if (dataType == null) {
            throw new IllegalArgumentException("Unsupported value class: " + valueClass);
        }
        return dataType;
    }

    private static void writeParamDescription(ByteBuf buffer, String name, boolean out, int id) {
        ByteBufUtils.writeByteLengthString(buffer, name);
        buffer.writeShort((out ? 1 : 0) << 8 | id & 0xFF);
    }

    private static void writeParamSize(ByteBuf buffer, int i, int j) {
        buffer.writeShort(i << 8 | j & 0xFF);
    }

    private static LocalDate decodeLocalDate(ByteBuf byteBuf, int length) {
        if (length == 3) {
            int days = byteBuf.readUnsignedMediumLE();
            return START_DATE.plus(days, ChronoUnit.DAYS);
        }
        throw new IllegalArgumentException("Invalid length: " + length);
    }

    private static LocalTime decodeLocalTime(ByteBuf byteBuf, int length, int scale) {
        long hundredNanos;
        if (length == 3) {
            hundredNanos = byteBuf.readUnsignedMediumLE();
        } else if (length == 4) {
            hundredNanos = byteBuf.readUnsignedIntLE();
        } else if (length == 5) {
            hundredNanos = ByteBufUtils.readUnsignedInt40LE(byteBuf);
        } else {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        for (int i = scale; i < 7; ++i) {
            hundredNanos *= 10L;
        }
        return LocalTime.ofNanoOfDay(100L * hundredNanos);
    }

    private static int daysFromStartDate(LocalDate localDate) {
        return (int)ChronoUnit.DAYS.between(START_DATE, localDate);
    }

    private static long hundredsOfNanos(LocalTime localTime) {
        return localTime.toNanoOfDay() / 100L;
    }

    static {
        START_DATE = LocalDate.of(1, 1, 1);
        START_DATE_DATETIME = LocalDate.of(1900, 1, 1);
        typesById = new IntObjectHashMap(DataType.values().length);
        for (DataType dataType : DataType.values()) {
            typesById.put(dataType.id, (Object)dataType);
        }
        typesByValueClass = new HashMap();
        typesByValueClass.put(Byte.class, INTN);
        typesByValueClass.put(Short.class, INTN);
        typesByValueClass.put(Integer.class, INTN);
        typesByValueClass.put(Long.class, INTN);
        typesByValueClass.put(Boolean.class, BITN);
        typesByValueClass.put(Float.class, FLTN);
        typesByValueClass.put(Double.class, FLTN);
        typesByValueClass.put(BigDecimal.class, DECIMALN);
        typesByValueClass.put(String.class, NVARCHAR);
        typesByValueClass.put(LocalDate.class, DATEN);
        typesByValueClass.put(LocalTime.class, TIMEN);
        typesByValueClass.put(LocalDateTime.class, DATETIME2N);
        typesByValueClass.put(OffsetDateTime.class, DATETIMEOFFSETN);
        typesByValueClass.put(UUID.class, GUID);
        typesByValueClass.put(Buffer.class, BIGVARBINARY);
    }
}

