/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.MultiMap;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.eventbus.Message;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.command.base.BusPublish;

@Name(value="bus-send")
@Summary(value="Send a message to the event bus")
public class BusSend
extends BusPublish {
    private boolean reply;

    @Option(longName="timeout")
    @Description(value="the send timeout")
    public void setTimeout(long timeout) {
        this.options.setSendTimeout(timeout);
    }

    @Option(longName="reply", flag=true)
    @Description(value="wait for a reply and print it on the console")
    public void setReply(boolean reply) {
        this.reply = reply;
    }

    @Override
    public void process(CommandProcess process) {
        Object body = this.parseBody();
        if (this.reply) {
            process.vertx().eventBus().request(this.address, body, this.options, ar -> {
                if (ar.succeeded()) {
                    Message reply = (Message)ar.result();
                    if (this.verbose) {
                        process.write("Reply address: " + reply.replyAddress() + "\n");
                        MultiMap headers = reply.headers();
                        for (String header : headers.names()) {
                            process.write("Reply header " + header + ":" + headers.getAll(header) + "\n");
                        }
                    }
                    process.write("Reply: <");
                    process.write(String.valueOf(reply.body())).write(">\n");
                } else {
                    process.write("Error: " + ar.cause().getMessage() + "\n");
                }
                process.end();
            });
        } else {
            process.vertx().eventBus().send(this.address, body, this.options);
            process.end();
        }
    }
}

