/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.streams.ReadStream;

@VertxGen
public interface HttpServer
extends Measured {
    @CacheReturn
    public ReadStream<HttpServerRequest> requestStream();

    @Fluent
    public HttpServer requestHandler(Handler<HttpServerRequest> var1);

    @GenIgnore
    public Handler<HttpServerRequest> requestHandler();

    public HttpServer invalidRequestHandler(Handler<HttpServerRequest> var1);

    @Fluent
    public HttpServer connectionHandler(Handler<HttpConnection> var1);

    @Fluent
    public HttpServer exceptionHandler(Handler<Throwable> var1);

    @CacheReturn
    public ReadStream<ServerWebSocket> webSocketStream();

    @Fluent
    public HttpServer webSocketHandler(Handler<ServerWebSocket> var1);

    @GenIgnore
    public Handler<ServerWebSocket> webSocketHandler();

    public Future<HttpServer> listen();

    default public Future<HttpServer> listen(int port, String host) {
        return this.listen(new SocketAddressImpl(port, host));
    }

    @Fluent
    default public HttpServer listen(int port, String host, Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen(port, host);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    @Fluent
    default public HttpServer listen(SocketAddress address, Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen(address);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    public Future<HttpServer> listen(SocketAddress var1);

    default public Future<HttpServer> listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    @Fluent
    default public HttpServer listen(int port, Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen(port);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    @Fluent
    default public HttpServer listen(Handler<AsyncResult<HttpServer>> listenHandler) {
        Future<HttpServer> fut = this.listen();
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    public int actualPort();
}

