/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.HAProxyMessageCompletionHandler;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.core.net.impl.TCPServerBase;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.ReadStream;

public class NetServerImpl
extends TCPServerBase
implements Closeable,
MetricsProvider,
NetServer {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    private final NetSocketStream connectStream = new NetSocketStream();
    private long demand = Long.MAX_VALUE;
    private Handler<NetSocket> handler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;

    public NetServerImpl(VertxInternal vertx, NetServerOptions options) {
        super(vertx, options);
    }

    private synchronized void pauseAccepting() {
        this.demand = 0L;
    }

    private synchronized void resumeAccepting() {
        this.demand = Long.MAX_VALUE;
    }

    private synchronized void fetchAccepting(long amount) {
        if (amount > 0L) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
        }
    }

    protected synchronized boolean accept() {
        boolean accept;
        boolean bl = accept = this.demand > 0L;
        if (accept && this.demand != Long.MAX_VALUE) {
            --this.demand;
        }
        return accept;
    }

    @Override
    public synchronized Handler<NetSocket> connectHandler() {
        return this.handler;
    }

    @Override
    public synchronized NetServer connectHandler(Handler<NetSocket> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set connectHandler when server is listening");
        }
        this.handler = handler;
        return this;
    }

    @Override
    public synchronized NetServer exceptionHandler(Handler<Throwable> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set exceptionHandler when server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    protected TCPMetrics<?> createMetrics(SocketAddress localAddress) {
        VertxMetrics vertxMetrics = this.vertx.metricsSPI();
        if (vertxMetrics != null) {
            return vertxMetrics.createNetServerMetrics(this.options, localAddress);
        }
        return null;
    }

    @Override
    public Future<Void> close() {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = context.promise();
        this.close((Promise<Void>)promise);
        return promise.future();
    }

    @Override
    protected Handler<Channel> childHandler(ContextInternal context, SocketAddress socketAddress, SSLHelper sslHelper) {
        return new NetServerWorker(context, sslHelper, this.handler, this.exceptionHandler);
    }

    @Override
    public synchronized Future<NetServer> listen(SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("No null bind local address");
        }
        if (this.handler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        return this.bind(localAddress).map(this);
    }

    @Override
    public Future<NetServer> listen() {
        return this.listen(this.options.getPort(), this.options.getHost());
    }

    @Override
    public ReadStream<NetSocket> connectStream() {
        return this.connectStream;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        ContextInternal context = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = context.promise();
        this.close((Promise<Void>)promise);
        promise.future().onComplete(completionHandler);
    }

    @Override
    public synchronized void close(Promise<Void> completion) {
        super.close(completion);
        Handler<Void> handler = this.endHandler;
        if (this.endHandler != null) {
            this.endHandler = null;
            completion.future().onComplete(ar -> handler.handle(null));
        }
    }

    public boolean isClosed() {
        return !this.isListening();
    }

    protected void initChannel(ChannelPipeline pipeline, boolean ssl) {
        if (this.options.getLogActivity()) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.options.getActivityLogDataFormat()));
        }
        if (ssl) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        int idleTimeout = this.options.getIdleTimeout();
        int readIdleTimeout = this.options.getReadIdleTimeout();
        int writeIdleTimeout = this.options.getWriteIdleTimeout();
        if (idleTimeout > 0 || readIdleTimeout > 0 || writeIdleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler((long)readIdleTimeout, (long)writeIdleTimeout, (long)idleTimeout, this.options.getIdleTimeoutUnit()));
        }
    }

    private class NetSocketStream
    implements ReadStream<NetSocket> {
        private NetSocketStream() {
        }

        public NetSocketStream handler(Handler<NetSocket> handler) {
            NetServerImpl.this.connectHandler(handler);
            return this;
        }

        public NetSocketStream pause() {
            NetServerImpl.this.pauseAccepting();
            return this;
        }

        public NetSocketStream resume() {
            NetServerImpl.this.resumeAccepting();
            return this;
        }

        @Override
        public ReadStream<NetSocket> fetch(long amount) {
            NetServerImpl.this.fetchAccepting(amount);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetSocketStream endHandler(Handler<Void> handler) {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                NetServerImpl.this.endHandler = handler;
                return this;
            }
        }

        @Override
        public NetSocketStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }

    private class NetServerWorker
    implements Handler<Channel> {
        private final ContextInternal context;
        private SSLHelper sslHelper;
        private final Handler<NetSocket> connectionHandler;
        private final Handler<Throwable> exceptionHandler;

        NetServerWorker(ContextInternal context, SSLHelper sslHelper, Handler<NetSocket> connectionHandler, Handler<Throwable> exceptionHandler) {
            this.context = context;
            this.sslHelper = sslHelper;
            this.connectionHandler = connectionHandler;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void handle(Channel ch) {
            if (!NetServerImpl.this.accept()) {
                ch.close();
                return;
            }
            if (HAProxyMessageCompletionHandler.canUseProxyProtocol(NetServerImpl.this.options.isUseProxyProtocol())) {
                IdleStateHandler idle;
                io.netty.util.concurrent.Promise p = ch.eventLoop().newPromise();
                ch.pipeline().addLast(new ChannelHandler[]{new HAProxyMessageDecoder()});
                if (NetServerImpl.this.options.getProxyProtocolTimeout() > 0L) {
                    idle = new IdleStateHandler(0L, 0L, NetServerImpl.this.options.getProxyProtocolTimeout(), NetServerImpl.this.options.getProxyProtocolTimeoutUnit());
                    ch.pipeline().addLast("idle", (ChannelHandler)idle);
                } else {
                    idle = null;
                }
                ch.pipeline().addLast(new ChannelHandler[]{new HAProxyMessageCompletionHandler((io.netty.util.concurrent.Promise<Channel>)p)});
                p.addListener(future -> {
                    if (future.isSuccess()) {
                        if (idle != null) {
                            ch.pipeline().remove((ChannelHandler)idle);
                        }
                        this.configurePipeline((Channel)future.getNow());
                    } else {
                        this.handleException(future.cause());
                    }
                });
            } else {
                this.configurePipeline(ch);
            }
        }

        private void configurePipeline(Channel ch) {
            if (this.sslHelper.isSSL()) {
                ch.pipeline().addLast("ssl", this.sslHelper.createHandler(this.context));
                ChannelPromise p = ch.newPromise();
                ch.pipeline().addLast("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler((io.netty.util.concurrent.Promise<Void>)p));
                p.addListener(future -> {
                    if (future.isSuccess()) {
                        this.connected(ch);
                    } else {
                        this.handleException(future.cause());
                    }
                });
            } else {
                this.connected(ch);
            }
        }

        private void handleException(Throwable cause) {
            if (this.exceptionHandler != null) {
                this.context.emit(v -> this.exceptionHandler.handle(cause));
            }
        }

        private void connected(Channel ch) {
            NetServerImpl.this.initChannel(ch.pipeline(), this.sslHelper.isSSL());
            Metrics metrics = NetServerImpl.this.getMetrics();
            VertxHandler<NetSocketImpl> handler = VertxHandler.create(arg_0 -> this.lambda$connected$3((TCPMetrics)metrics, arg_0));
            handler.removeHandler(NetSocketImpl::unregisterEventBusHandler);
            handler.addHandler(arg_0 -> this.lambda$connected$4((TCPMetrics)metrics, arg_0));
            ch.pipeline().addLast("handler", handler);
        }

        private /* synthetic */ void lambda$connected$4(TCPMetrics metrics, NetSocketImpl conn) {
            if (metrics != null) {
                conn.metric(metrics.connected(conn.remoteAddress(), conn.remoteName()));
            }
            conn.registerEventBusHandler();
            this.context.emit(conn, this.connectionHandler::handle);
        }

        private /* synthetic */ NetSocketImpl lambda$connected$3(TCPMetrics metrics, ChannelHandlerContext ctx) {
            return new NetSocketImpl(this.context, ctx, this.sslHelper, metrics);
        }
    }
}

