/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class PropertyResolverUtils {
    private PropertyResolverUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static long getLongProperty(PropertyResolver resolver, String name, long defaultValue) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(resolver, name), defaultValue);
    }

    public static long getLongProperty(Map<String, ?> props, String name, long defaultValue) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(props, name), defaultValue);
    }

    public static long toLong(Object value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    public static Long getLong(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(resolver, name));
    }

    public static Long getLong(Map<String, ?> props, String name) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(props, name));
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.valueOf(value.toString());
    }

    public static Object updateProperty(PropertyResolver resolver, String name, long value) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, long value) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value);
    }

    public static int getIntProperty(PropertyResolver resolver, String name, int defaultValue) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(resolver, name), defaultValue);
    }

    public static int getIntProperty(Map<String, ?> props, String name, int defaultValue) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(props, name), defaultValue);
    }

    public static int toInteger(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public static Integer getInteger(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(resolver, name));
    }

    public static Integer getInteger(Map<String, ?> props, String name) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(props, name));
    }

    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static Object updateProperty(PropertyResolver resolver, String name, int value) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, int value) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value);
    }

    public static boolean getBooleanProperty(PropertyResolver resolver, String name, boolean defaultValue) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.getObject(resolver, name), defaultValue);
    }

    public static boolean getBooleanProperty(Map<String, ?> props, String name, boolean defaultValue) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.getObject(props, name), defaultValue);
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return PropertyResolverUtils.toBoolean(value);
    }

    public static Boolean getBoolean(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.resolvePropertyValue(resolver, name));
    }

    public static Boolean getBoolean(Map<String, ?> props, String name) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.resolvePropertyValue(props, name));
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public static Object updateProperty(PropertyResolver resolver, String name, boolean value) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, boolean value) {
        return PropertyResolverUtils.updateProperty(props, name, (Object)value);
    }

    public static String getStringProperty(PropertyResolver resolver, String name, String defaultValue) {
        String value = PropertyResolverUtils.getString(resolver, name);
        if (GenericUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public static String getStringProperty(Map<String, ?> props, String name, String defaultValue) {
        Object value = PropertyResolverUtils.resolvePropertyValue(props, name);
        if (value == null) {
            return defaultValue;
        }
        return Objects.toString(value);
    }

    public static String getString(PropertyResolver resolver, String name) {
        Object value = PropertyResolverUtils.getObject(resolver, name);
        return Objects.toString(value, null);
    }

    public static String getString(Map<String, ?> props, String name) {
        Object value = PropertyResolverUtils.getObject(props, name);
        return Objects.toString(value, null);
    }

    public static Object getObject(PropertyResolver resolver, String name) {
        return PropertyResolverUtils.resolvePropertyValue(resolver, name);
    }

    public static Object getObject(Map<String, ?> props, String name) {
        return PropertyResolverUtils.resolvePropertyValue(props, name);
    }

    public static Object resolvePropertyValue(Map<String, ?> props, String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        return GenericUtils.isEmpty(props) ? null : props.get(key);
    }

    public static Object updateProperty(PropertyResolver resolver, String name, Object value) {
        return PropertyResolverUtils.updateProperty(resolver.getProperties(), name, value);
    }

    public static Object updateProperty(Map<String, Object> props, String name, Object value) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        if (value == null || value instanceof CharSequence && GenericUtils.isEmpty((CharSequence)value)) {
            return props.remove(key);
        }
        return props.put(key, value);
    }

    public static Object resolvePropertyValue(PropertyResolver resolver, String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        for (PropertyResolver r = resolver; r != null; r = r.getParentPropertyResolver()) {
            Object value;
            Map<String, Object> props = r.getProperties();
            Object object = value = GenericUtils.isEmpty(props) ? null : props.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static Map<String, Object> resolvePropertiesSource(PropertyResolver resolver, String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        for (PropertyResolver r = resolver; r != null; r = r.getParentPropertyResolver()) {
            Object value;
            Map<String, Object> props = r.getProperties();
            Object object = value = GenericUtils.isEmpty(props) ? null : props.get(key);
            if (value == null) continue;
            return props;
        }
        return null;
    }

    public static PropertyResolver toPropertyResolver(Map<String, Object> props) {
        return PropertyResolverUtils.toPropertyResolver(props, null);
    }

    public static PropertyResolver toPropertyResolver(final Map<String, Object> props, final PropertyResolver parent) {
        return new PropertyResolver(){

            @Override
            public PropertyResolver getParentPropertyResolver() {
                return parent;
            }

            @Override
            public Map<String, Object> getProperties() {
                return props;
            }

            public String toString() {
                return Objects.toString(props);
            }
        };
    }
}

