/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.backend.redis;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class RedisBackendService
implements ServiceDiscoveryBackend {
    private Redis redis;
    private String key;

    public void init(Vertx vertx, JsonObject configuration) {
        this.key = configuration.getString("key", "records");
        this.redis = Redis.createClient((Vertx)vertx, (RedisOptions)new RedisOptions(configuration));
    }

    public void store(Record record, Handler<AsyncResult<Record>> resultHandler) {
        if (record.getRegistration() != null) {
            resultHandler.handle((Object)Future.failedFuture((String)"The record has already been registered"));
            return;
        }
        String uuid = UUID.randomUUID().toString();
        record.setRegistration(uuid);
        this.redis.send(Request.cmd((Command)Command.HSET).arg(this.key).arg(uuid).arg(record.toJson().encode()), ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)record));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void remove(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        this.remove(record.getRegistration(), resultHandler);
    }

    public void remove(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(uuid, "No registration id in the record");
        this.redis.send(Request.cmd((Command)Command.HGET).arg(this.key).arg(uuid), ar -> {
            if (ar.succeeded()) {
                if (ar.result() != null) {
                    this.redis.send(Request.cmd((Command)Command.HDEL).arg(this.key).arg(uuid), deletion -> {
                        if (deletion.succeeded()) {
                            resultHandler.handle((Object)Future.succeededFuture((Object)new Record(new JsonObject(((Response)ar.result()).toBuffer()))));
                        } else {
                            resultHandler.handle((Object)Future.failedFuture((Throwable)deletion.cause()));
                        }
                    });
                } else {
                    resultHandler.handle((Object)Future.failedFuture((String)("Record '" + uuid + "' not found")));
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        this.redis.send(Request.cmd((Command)Command.HSET).arg(this.key).arg(record.getRegistration()).arg(record.toJson().encode()), ar -> {
            if (ar.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void getRecords(Handler<AsyncResult<List<Record>>> resultHandler) {
        this.redis.send(Request.cmd((Command)Command.HGETALL).arg(this.key), ar -> {
            if (ar.succeeded()) {
                Response entries = (Response)ar.result();
                resultHandler.handle((Object)Future.succeededFuture(entries.getKeys().stream().map(key -> new Record(new JsonObject(entries.get(key).toBuffer()))).collect(Collectors.toList())));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void getRecord(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        this.redis.send(Request.cmd((Command)Command.HGET).arg(this.key).arg(uuid), ar -> {
            if (ar.succeeded()) {
                if (ar.result() != null) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)new Record(new JsonObject(((Response)ar.result()).toBuffer()))));
                } else {
                    resultHandler.handle((Object)Future.succeededFuture(null));
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }
}

