/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompServer;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.StompServerHandler;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class StompServerConnectionImpl
implements StompServerConnection {
    private static final Logger log = LoggerFactory.getLogger(StompServerConnectionImpl.class);
    private final StompServer server;
    private final NetSocket socket;
    private final String sessionId;
    private volatile long lastClientActivity;
    private long pinger = -1L;
    private long ponger = -1L;

    public StompServerConnectionImpl(NetSocket socket, StompServer server) {
        Objects.requireNonNull(socket);
        Objects.requireNonNull(server);
        this.socket = socket;
        this.server = server;
        this.sessionId = UUID.randomUUID().toString();
    }

    @Override
    public StompServerConnection write(Frame frame) {
        return this.write(frame.toBuffer());
    }

    @Override
    public StompServerConnection write(Buffer buffer) {
        this.socket.write(buffer);
        return this;
    }

    @Override
    public StompServer server() {
        return this.server;
    }

    @Override
    public StompServerHandler handler() {
        return this.server.stompHandler();
    }

    @Override
    public String session() {
        return this.sessionId;
    }

    @Override
    public void close() {
        this.cancelHeartbeat();
        this.handler().onClose(this);
        this.socket.close();
    }

    @Override
    public void ping() {
        this.socket.write(Buffer.buffer((String)"\n"));
    }

    public synchronized void cancelHeartbeat() {
        if (this.pinger > 0L) {
            this.server.vertx().cancelTimer(this.pinger);
            this.pinger = 0L;
        }
        if (this.ponger > 0L) {
            this.server.vertx().cancelTimer(this.ponger);
            this.ponger = 0L;
        }
    }

    @Override
    public void onServerActivity() {
        this.lastClientActivity = System.nanoTime();
    }

    @Override
    public synchronized void configureHeartbeat(long ping, long pong, Handler<StompServerConnection> pingHandler) {
        if (ping > 0L) {
            this.pinger = this.server.vertx().setPeriodic(ping, l -> pingHandler.handle((Object)this));
        }
        if (pong > 0L) {
            this.ponger = this.server.vertx().setPeriodic(pong, l -> {
                long delta = System.nanoTime() - this.lastClientActivity;
                long deltaInMs = TimeUnit.MILLISECONDS.convert(delta, TimeUnit.NANOSECONDS);
                if (deltaInMs > pong * 2L) {
                    log.warn((Object)("Disconnecting client " + this + " - no client activity in the last " + deltaInMs + " ms"));
                    this.close();
                }
            });
        }
    }
}

