/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClient;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompClientConnection;
import io.vertx.ext.stomp.StompClientOptions;
import io.vertx.ext.stomp.impl.StompClientImpl;

@VertxGen
public interface StompClient {
    public static StompClient create(Vertx vertx) {
        return StompClient.create(vertx, new StompClientOptions());
    }

    public static StompClient create(Vertx vertx, StompClientOptions options) {
        return new StompClientImpl(vertx, options);
    }

    @Fluent
    public StompClient connect(int var1, String var2, Handler<AsyncResult<StompClientConnection>> var3);

    @Fluent
    public StompClient connect(NetClient var1, Handler<AsyncResult<StompClientConnection>> var2);

    @Fluent
    public StompClient connect(int var1, String var2, NetClient var3, Handler<AsyncResult<StompClientConnection>> var4);

    @Fluent
    public StompClient connect(Handler<AsyncResult<StompClientConnection>> var1);

    @Fluent
    public StompClient receivedFrameHandler(Handler<Frame> var1);

    @Fluent
    public StompClient writingFrameHandler(Handler<Frame> var1);

    @Fluent
    public StompClient errorFrameHandler(Handler<Frame> var1);

    @Fluent
    public StompClient exceptionHandler(Handler<Throwable> var1);

    public void close();

    public StompClientOptions options();

    public Vertx vertx();

    public boolean isClosed();
}

