/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.NetServer;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.StompServerHandler;
import io.vertx.ext.stomp.StompServerOptions;
import io.vertx.ext.stomp.impl.StompServerImpl;

@VertxGen
public interface StompServer {
    public static StompServer create(Vertx vertx, StompServerOptions options) {
        return new StompServerImpl(vertx, null, options);
    }

    public static StompServer create(Vertx vertx, NetServer netServer) {
        return new StompServerImpl(vertx, netServer, new StompServerOptions());
    }

    public static StompServer create(Vertx vertx, NetServer net, StompServerOptions options) {
        return new StompServerImpl(vertx, net, options);
    }

    public static StompServer create(Vertx vertx) {
        return StompServer.create(vertx, new StompServerOptions());
    }

    @Fluent
    public StompServer handler(StompServerHandler var1);

    @Fluent
    public StompServer listen(int var1);

    @Fluent
    public StompServer listen(int var1, String var2);

    @Fluent
    public StompServer listen();

    @Fluent
    public StompServer listen(Handler<AsyncResult<StompServer>> var1);

    @Fluent
    public StompServer listen(int var1, Handler<AsyncResult<StompServer>> var2);

    @Fluent
    public StompServer listen(int var1, String var2, Handler<AsyncResult<StompServer>> var3);

    public void close(Handler<AsyncResult<Void>> var1);

    public void close();

    public boolean isListening();

    public int actualPort();

    public StompServerOptions options();

    public Vertx vertx();

    public StompServerHandler stompHandler();

    public Handler<ServerWebSocket> webSocketHandler();

    @Fluent
    public StompServer writingFrameHandler(Handler<ServerFrame> var1);
}

