/*
 *  Copyright (c) 2011-2015 The original author or authors
 *  ------------------------------------------------------
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  and Apache License v2.0 which accompanies this distribution.
 *
 *       The Eclipse Public License is available at
 *       http://www.eclipse.org/legal/epl-v10.html
 *
 *       The Apache License v2.0 is available at
 *       http://www.opensource.org/licenses/apache2.0.php
 *
 *  You may elect to redistribute this code under either of these licenses.
 */

package io.vertx.ext.stomp.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

/**
 * Class responsible for the computation of the server id. From the STOMP specification, this id must be constructed as
 * follows: name/version comments.
 *
 * @author <a href="http://escoffier.me">Clement Escoffier</a>
 */
public class Server {

  public static final String SERVER_NAME;

  static {
    try (InputStream is = Server.class.getClassLoader().getResourceAsStream("vertx-stomp-version.txt")) {
      if (is == null) {
        throw new IllegalStateException("Cannot find vertx-stomp-version.txt on classpath");
      }
      try (Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A")) {
        SERVER_NAME = "vertx-stomp" + (scanner.hasNext() ? "/" + scanner.next() : "");
      }
    } catch (IOException e) {
      throw new IllegalStateException(e.getMessage());
    }
  }

}
