/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.NetClientInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.stomp.Command;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompClient;
import io.vertx.ext.stomp.StompClientConnection;
import io.vertx.ext.stomp.StompClientOptions;
import io.vertx.ext.stomp.impl.StompClientConnectionImpl;
import io.vertx.ext.stomp.utils.Headers;
import java.util.concurrent.TimeUnit;

public class StompClientImpl
implements StompClient {
    private static final Logger log = LoggerFactory.getLogger(StompClientImpl.class);
    private final Vertx vertx;
    private final StompClientOptions options;
    private final NetClientInternal client;
    private Handler<Frame> receivedFrameHandler;
    private Handler<Frame> writingFrameHandler;
    private Handler<Frame> errorFrameHandler;
    private Handler<Throwable> exceptionHandler;

    public StompClientImpl(Vertx vertx, StompClientOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.client = (NetClientInternal)vertx.createNetClient((NetClientOptions)options);
    }

    public StompClient connect(Completable<StompClientConnection> resultHandler) {
        return this.connect(this.options.getPort(), this.options.getHost(), resultHandler);
    }

    @Override
    public Future<StompClientConnection> connect() {
        Promise promise = Promise.promise();
        this.connect((Completable<StompClientConnection>)promise);
        return promise.future();
    }

    @Override
    public synchronized StompClient receivedFrameHandler(Handler<Frame> handler) {
        this.receivedFrameHandler = handler;
        return this;
    }

    @Override
    public synchronized StompClient writingFrameHandler(Handler<Frame> handler) {
        this.writingFrameHandler = handler;
        return this;
    }

    @Override
    public synchronized StompClient errorFrameHandler(Handler<Frame> handler) {
        this.errorFrameHandler = handler;
        return this;
    }

    @Override
    public synchronized StompClient exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized Future<Void> close() {
        return this.client.shutdown(10L, TimeUnit.SECONDS);
    }

    @Override
    public StompClientOptions options() {
        return this.options;
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.client == null;
    }

    public synchronized StompClient connect(int port, String host, Completable<StompClientConnection> resultHandler) {
        Handler<Frame> r = this.receivedFrameHandler;
        Handler<Frame> w = this.writingFrameHandler;
        Handler<Throwable> err = this.exceptionHandler;
        this.client.connect(port, host).onComplete(ar -> {
            if (ar.failed()) {
                if (resultHandler != null) {
                    resultHandler.fail(ar.cause());
                } else {
                    log.error((Object)"Unable to connect to the server", ar.cause());
                }
            } else {
                ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
                NetSocket so = (NetSocket)ar.result();
                StompClientConnection stompClientConnection = new StompClientConnectionImpl(ctx, so, this.options).receivedFrameHandler(r).writingFrameHandler(w).exceptionHandler(err).errorHandler(this.errorFrameHandler);
                Frame frame = this.getConnectFrame(host);
                ctx.setTimer((long)this.options.getConnectTimeout(), l -> {
                    if (!stompClientConnection.isConnected()) {
                        stompClientConnection.close();
                    }
                });
                if (w != null) {
                    w.handle((Object)frame);
                }
                so.write((Object)frame.toBuffer(this.options.isTrailingLine()));
                ((StompClientConnectionImpl)stompClientConnection).connectFuture().map((Object)stompClientConnection).onComplete(resultHandler);
            }
        });
        return this;
    }

    @Override
    public Future<StompClientConnection> connect(int port, String host) {
        Promise promise = Promise.promise();
        this.connect(port, host, (Completable<StompClientConnection>)promise);
        return promise.future();
    }

    private Frame getConnectFrame(String host) {
        Headers headers = Headers.create();
        String accepted = this.getAcceptedVersions();
        if (accepted != null) {
            headers.put("accept-version", accepted);
        }
        if (!this.options.isBypassHostHeader()) {
            headers.put("host", host);
        }
        if (this.options.getVirtualHost() != null) {
            headers.put("host", this.options.getVirtualHost());
        }
        if (this.options.getLogin() != null) {
            headers.put("login", this.options.getLogin());
        }
        if (this.options.getPasscode() != null) {
            headers.put("passcode", this.options.getPasscode());
        }
        headers.put("heart-beat", Frame.Heartbeat.create(this.options.getHeartbeat()).toString());
        Command cmd = this.options.isUseStompFrame() ? Command.STOMP : Command.CONNECT;
        return new Frame(cmd, headers, null);
    }

    private String getAcceptedVersions() {
        if (this.options.getAcceptedVersions() == null || this.options.getAcceptedVersions().isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        this.options.getAcceptedVersions().forEach(version -> builder.append((String)(builder.length() == 0 ? version : "," + version)));
        return builder.toString();
    }
}

