/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp.impl.protocol;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.WriteStream;
import java.nio.charset.Charset;

public class FrameHelper {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    private FrameHelper() {
    }

    public static void sendFrame(String type, String address, String replyAddress, JsonObject headers, Boolean send, JsonObject body, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", type);
        if (address != null) {
            payload.put("address", address);
        }
        if (replyAddress != null) {
            payload.put("replyAddress", replyAddress);
        }
        if (headers != null) {
            payload.put("headers", headers);
        }
        if (body != null) {
            payload.put("body", body);
        }
        if (send != null) {
            payload.put("send", send);
        }
        FrameHelper.writeFrame(payload, handler);
    }

    public static void sendFrame(String type, String address, String replyAddress, JsonObject body, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, address, replyAddress, null, null, body, handler);
    }

    public static void sendFrame(String type, String address, JsonObject body, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, address, null, null, null, body, handler);
    }

    public static void sendFrame(String type, WriteStream<Buffer> handler) {
        FrameHelper.sendFrame(type, null, null, null, null, null, handler);
    }

    public static void sendErrFrame(String address, String replyAddress, ReplyException failure, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", "err").put("address", replyAddress).put("sourceAddress", address).put("failureCode", Integer.valueOf(failure.failureCode())).put("failureType", failure.failureType().name()).put("message", failure.getMessage());
        FrameHelper.writeFrame(payload, handler);
    }

    public static void sendErrFrame(String message, WriteStream<Buffer> handler) {
        JsonObject payload = new JsonObject().put("type", "err").put("message", message);
        FrameHelper.writeFrame(payload, handler);
    }

    public static void writeFrame(JsonObject payload, WriteStream<Buffer> handler) {
        byte[] data = payload.encode().getBytes(UTF8);
        handler.write((Object)Buffer.buffer().appendInt(data.length).appendBytes(data));
    }
}

