/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.eventbus.bridge.tcp.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.BridgeEvent;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import io.vertx.ext.eventbus.bridge.tcp.impl.BridgeEventImpl;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TcpEventBusBridgeImpl
implements TcpEventBusBridge {
    private static final Logger log = LoggerFactory.getLogger(TcpEventBusBridgeImpl.class);
    private final EventBus eb;
    private final NetServer server;
    private final Map<String, Pattern> compiledREs = new HashMap<String, Pattern>();
    private final BridgeOptions options;
    private final Handler<BridgeEvent> bridgeEventHandler;

    public TcpEventBusBridgeImpl(Vertx vertx, BridgeOptions options, NetServerOptions netServerOptions, Handler<BridgeEvent> eventHandler) {
        this.eb = vertx.eventBus();
        this.options = options != null ? options : new BridgeOptions();
        this.bridgeEventHandler = eventHandler;
        this.server = vertx.createNetServer(netServerOptions == null ? new NetServerOptions() : netServerOptions);
        this.server.connectHandler(this::handler);
    }

    @Override
    public Future<TcpEventBusBridge> listen() {
        return this.server.listen().map((Object)this);
    }

    @Override
    public Future<TcpEventBusBridge> listen(int port) {
        return this.server.listen(port).map((Object)this);
    }

    @Override
    public Future<TcpEventBusBridge> listen(int port, String address) {
        return this.server.listen(port, address).map((Object)this);
    }

    @Override
    public TcpEventBusBridge listen(Handler<AsyncResult<TcpEventBusBridge>> handler) {
        this.server.listen(res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)this));
            }
        });
        return this;
    }

    @Override
    public TcpEventBusBridge listen(int port, String address, Handler<AsyncResult<TcpEventBusBridge>> handler) {
        this.server.listen(port, address, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)this));
            }
        });
        return this;
    }

    @Override
    public TcpEventBusBridge listen(int port, Handler<AsyncResult<TcpEventBusBridge>> handler) {
        this.server.listen(port, res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)this));
            }
        });
        return this;
    }

    private void doSendOrPub(NetSocket socket, String address, JsonObject msg, Map<String, MessageConsumer<?>> registry, Map<String, Message<?>> replies) {
        Object body = msg.getValue("body");
        JsonObject headers = msg.getJsonObject("headers");
        String type = msg.getString("type", "message");
        DeliveryOptions deliveryOptions = this.parseMsgHeaders(new DeliveryOptions(), headers);
        switch (type) {
            case "send": {
                if (this.checkMatches(true, address, replies)) {
                    String replyAddress = msg.getString("replyAddress");
                    if (replyAddress != null) {
                        this.eb.request(address, body, deliveryOptions, res1 -> {
                            if (res1.failed()) {
                                FrameHelper.sendErrFrame(address, replyAddress, (ReplyException)res1.cause(), (WriteStream<Buffer>)socket);
                            } else {
                                Message response = (Message)res1.result();
                                JsonObject responseHeaders = new JsonObject();
                                for (Map.Entry entry : response.headers()) {
                                    responseHeaders.put((String)entry.getKey(), entry.getValue());
                                }
                                if (response.replyAddress() != null) {
                                    replies.put(response.replyAddress(), response);
                                }
                                FrameHelper.sendFrame("message", replyAddress, response.replyAddress(), responseHeaders, true, response.body(), (WriteStream<Buffer>)socket);
                            }
                        });
                    } else if (replies.containsKey(address)) {
                        Integer failureCode = msg.getInteger("failureCode");
                        if (failureCode == null) {
                            replies.get(address).reply(body, deliveryOptions);
                        } else {
                            replies.get(address).fail(msg.getInteger("failureCode").intValue(), msg.getString("message"));
                        }
                    } else {
                        this.eb.send(address, body, deliveryOptions);
                    }
                    replies.remove(address);
                    break;
                }
                FrameHelper.sendErrFrame("access_denied", (WriteStream<Buffer>)socket);
                break;
            }
            case "publish": {
                if (this.checkMatches(true, address)) {
                    this.eb.publish(address, body, deliveryOptions);
                    break;
                }
                FrameHelper.sendErrFrame("access_denied", (WriteStream<Buffer>)socket);
                break;
            }
            case "register": {
                if (this.checkMatches(false, address)) {
                    registry.put(address, this.eb.consumer(address, res1 -> {
                        if (res1.replyAddress() != null) {
                            replies.put(res1.replyAddress(), (Message<?>)res1);
                        }
                        JsonObject responseHeaders = new JsonObject();
                        for (Map.Entry entry : res1.headers()) {
                            responseHeaders.put((String)entry.getKey(), entry.getValue());
                        }
                        FrameHelper.sendFrame("message", res1.address(), res1.replyAddress(), responseHeaders, res1.isSend(), res1.body(), (WriteStream<Buffer>)socket);
                    }));
                    this.checkCallHook(() -> new BridgeEventImpl(BridgeEventType.REGISTERED, msg, socket), null, null);
                    break;
                }
                FrameHelper.sendErrFrame("access_denied", (WriteStream<Buffer>)socket);
                break;
            }
            case "unregister": {
                if (this.checkMatches(false, address)) {
                    MessageConsumer<?> consumer = registry.remove(address);
                    if (consumer != null) {
                        consumer.unregister();
                        break;
                    }
                    FrameHelper.sendErrFrame("unknown_address", (WriteStream<Buffer>)socket);
                    break;
                }
                FrameHelper.sendErrFrame("access_denied", (WriteStream<Buffer>)socket);
                break;
            }
            case "ping": {
                FrameHelper.sendFrame("pong", (WriteStream<Buffer>)socket);
                break;
            }
            default: {
                FrameHelper.sendErrFrame("unknown_type", (WriteStream<Buffer>)socket);
            }
        }
    }

    private void handler(NetSocket socket) {
        ConcurrentHashMap registry = new ConcurrentHashMap();
        ConcurrentHashMap replies = new ConcurrentHashMap();
        FrameParser parser = new FrameParser((Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.failed()) {
                log.error((Object)res.cause());
                return;
            }
            JsonObject msg = (JsonObject)res.result();
            String type = msg.getString("type", "message");
            String address = msg.getString("address");
            BridgeEventType eventType = TcpEventBusBridgeImpl.parseType(type);
            this.checkCallHook(() -> new BridgeEventImpl(eventType, msg, socket), () -> {
                if (eventType != BridgeEventType.SOCKET_PING && address == null) {
                    FrameHelper.sendErrFrame("missing_address", (WriteStream<Buffer>)socket);
                    log.error((Object)("msg does not have address: " + msg));
                    return;
                }
                this.doSendOrPub(socket, address, msg, registry, replies);
            }, () -> FrameHelper.sendErrFrame("blocked by bridgeEvent handler", (WriteStream<Buffer>)socket));
        }));
        socket.handler((Handler)parser);
        socket.exceptionHandler(t -> {
            log.error((Object)t.getMessage(), t);
            registry.values().forEach(MessageConsumer::unregister);
            registry.clear();
            socket.close();
        });
        socket.endHandler(v -> {
            registry.values().forEach(MessageConsumer::unregister);
            registry.clear();
        });
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.server.close(handler);
    }

    @Override
    public Future<Void> close() {
        return this.server.close();
    }

    private void checkCallHook(Supplier<BridgeEventImpl> eventSupplier, Runnable okAction, Runnable rejectAction) {
        if (this.bridgeEventHandler == null) {
            if (okAction != null) {
                okAction.run();
            }
        } else {
            BridgeEventImpl event = eventSupplier.get();
            this.bridgeEventHandler.handle((Object)event);
            event.future().onComplete(res -> {
                if (res.succeeded()) {
                    if (((Boolean)res.result()).booleanValue()) {
                        if (okAction != null) {
                            okAction.run();
                        }
                    } else if (rejectAction != null) {
                        rejectAction.run();
                    } else {
                        log.debug((Object)"Bridge handler prevented send or pub");
                    }
                } else {
                    log.error((Object)"Failure in bridge event handler", res.cause());
                }
            });
        }
    }

    private boolean checkMatches(boolean inbound, String address) {
        return this.checkMatches(inbound, address, null);
    }

    private boolean checkMatches(boolean inbound, String address, Map<String, Message<?>> replies) {
        if (replies != null && inbound && replies.containsKey(address)) {
            return true;
        }
        List matches = inbound ? this.options.getInboundPermitteds() : this.options.getOutboundPermitteds();
        for (PermittedOptions matchHolder : matches) {
            String matchAddress = matchHolder.getAddress();
            String matchRegex = matchAddress == null ? matchHolder.getAddressRegex() : null;
            boolean addressOK = matchAddress == null ? matchRegex == null || this.regexMatches(matchRegex, address) : matchAddress.equals(address);
            if (!addressOK) continue;
            return true;
        }
        return false;
    }

    private boolean regexMatches(String matchRegex, String address) {
        Pattern pattern = this.compiledREs.get(matchRegex);
        if (pattern == null) {
            pattern = Pattern.compile(matchRegex);
            this.compiledREs.put(matchRegex, pattern);
        }
        Matcher m = pattern.matcher(address);
        return m.matches();
    }

    private DeliveryOptions parseMsgHeaders(DeliveryOptions options, JsonObject headers) {
        if (headers == null) {
            return options;
        }
        for (String fname : headers.fieldNames()) {
            if ("timeout".equals(fname)) {
                options.setSendTimeout(headers.getLong(fname).longValue());
                continue;
            }
            if ("localOnly".equals(fname)) {
                options.setLocalOnly(headers.getBoolean(fname).booleanValue());
                continue;
            }
            if ("codecName".equals(fname)) {
                options.setCodecName(headers.getString(fname));
                continue;
            }
            options.addHeader(fname, headers.getString(fname));
        }
        return options;
    }

    private static BridgeEventType parseType(String typeStr) {
        switch (typeStr) {
            case "ping": {
                return BridgeEventType.SOCKET_PING;
            }
            case "register": {
                return BridgeEventType.REGISTER;
            }
            case "unregister": {
                return BridgeEventType.UNREGISTER;
            }
            case "publish": {
                return BridgeEventType.PUBLISH;
            }
            case "send": {
                return BridgeEventType.SEND;
            }
        }
        throw new IllegalArgumentException("Invalid frame type " + typeStr);
    }
}

