/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.report.ReportOptions;
import io.vertx.ext.unit.report.ReportingOptions;
import java.util.List;

@DataObject
public class TestOptions
extends ReportingOptions {
    public static final long DEFAULT_TIMEOUT = 120000L;
    public static final Boolean DEFAULT_USE_EVENT_LOOP = null;
    private long timeout = 120000L;
    private Boolean useEventLoop = DEFAULT_USE_EVENT_LOOP;

    public TestOptions() {
    }

    public TestOptions(TestOptions other) {
        super(other);
        this.setTimeout(other.timeout);
        this.setUseEventLoop(other.useEventLoop);
    }

    public TestOptions(JsonObject json) {
        super(json);
        this.setTimeout(json.getLong("timeout", Long.valueOf(120000L)));
        this.setUseEventLoop(json.getBoolean("useEventLoop", DEFAULT_USE_EVENT_LOOP));
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Fluent
    public TestOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public Boolean isUseEventLoop() {
        return this.useEventLoop;
    }

    @Fluent
    public TestOptions setUseEventLoop(Boolean useEventLoop) {
        this.useEventLoop = useEventLoop;
        return this;
    }

    @Override
    public TestOptions addReporter(ReportOptions reportOptions) {
        return (TestOptions)super.addReporter(reportOptions);
    }

    @Override
    public TestOptions setReporters(List<ReportOptions> reporters) {
        return (TestOptions)super.setReporters(reporters);
    }

    @Override
    public JsonObject toJson() {
        JsonObject config = super.toJson();
        config.put("timeout", Long.valueOf(this.timeout));
        if (this.useEventLoop != null) {
            config.put("useEventLoop", this.useEventLoop);
        }
        return config;
    }
}

