/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.unit.TestCompletion;
import io.vertx.ext.unit.impl.Helper;
import io.vertx.ext.unit.report.Reporter;
import io.vertx.ext.unit.report.TestResult;
import io.vertx.ext.unit.report.TestSuiteReport;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class ReporterHandler
implements Handler<TestSuiteReport>,
TestCompletion {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Reporter[] reporters;
    private volatile Future<?> completion;
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private volatile boolean completed;

    public ReporterHandler(Reporter ... reporters) {
        this((Future)null, reporters);
    }

    public ReporterHandler(Future completion, Reporter ... reporters) {
        this.completion = completion;
        this.reporters = reporters;
    }

    @Override
    public void resolve(Future future) {
        this.completion = future;
        if (this.completed) {
            if (this.failure.get() == null) {
                future.complete();
            } else {
                future.fail(this.failure.get());
            }
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isSucceeded() {
        return this.completed && this.failure.get() == null;
    }

    @Override
    public boolean isFailed() {
        return this.completed && this.failure.get() != null;
    }

    @Override
    public void handler(Handler<AsyncResult<Void>> completionHandler) {
        Future completion = Future.future();
        completion.setHandler(completionHandler);
        this.resolve(completion);
    }

    public void handle(TestSuiteReport testsuite) {
        Object[] reports = new Object[this.reporters.length];
        for (int i = 0; i < this.reporters.length; ++i) {
            reports[i] = this.reporters[i].reportBeginTestSuite(testsuite.name());
        }
        testsuite.handler(testcase -> {
            for (int i = 0; i < this.reporters.length; ++i) {
                this.reporters[i].reportBeginTestCase(reports[i], testcase.name());
            }
            testcase.endHandler((Handler<TestResult>)((Handler)result -> {
                if (result.failed()) {
                    this.failure.compareAndSet(null, result.failure().cause());
                }
                for (int i = 0; i < this.reporters.length; ++i) {
                    this.reporters[i].reportEndTestCase(reports[i], testcase.name(), (TestResult)result);
                }
            }));
        });
        AtomicReference err = new AtomicReference();
        testsuite.exceptionHandler(t -> {
            this.failure.compareAndSet((Throwable)null, (Throwable)t);
            err.set(t);
            for (int i = 0; i < this.reporters.length; ++i) {
                this.reporters[i].reportError(reports[i], (Throwable)t);
            }
        });
        testsuite.endHandler(v -> {
            for (int i = 0; i < this.reporters.length; ++i) {
                this.reporters[i].reportEndTestSuite(reports[i]);
            }
            this.completed = true;
            this.latch.countDown();
            if (this.completion != null) {
                if (this.failure.get() == null) {
                    this.completion.complete();
                } else {
                    this.completion.fail(this.failure.get());
                }
            }
        });
    }

    @Override
    public void await() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Helper.uncheckedThrow(e);
        }
    }

    @Override
    public void await(long timeoutMillis) {
        try {
            boolean ok = this.latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            if (!ok) {
                Helper.uncheckedThrow(new TimeoutException("Timed out"));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Helper.uncheckedThrow(e);
        }
    }

    @Override
    public void awaitSuccess() {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        Future future = Future.future();
        future.setHandler(queue::add);
        AsyncResult result = null;
        this.resolve(future);
        try {
            result = (AsyncResult)queue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Helper.uncheckedThrow(e);
        }
        if (result == null) {
            Helper.uncheckedThrow(new TimeoutException("Timed out"));
        } else if (result.failed()) {
            Helper.uncheckedThrow(result.cause());
        }
    }

    @Override
    public void awaitSuccess(long timeoutMillis) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        Future future = Future.future();
        future.setHandler(queue::add);
        AsyncResult result = null;
        this.resolve(future);
        try {
            result = (AsyncResult)queue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Helper.uncheckedThrow(e);
        }
        if (result == null) {
            Helper.uncheckedThrow(new TimeoutException("Timed out"));
        } else if (result.failed()) {
            Helper.uncheckedThrow(result.cause());
        }
    }
}

