/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestCase;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.ExecutionContext;
import io.vertx.ext.unit.impl.Task;
import io.vertx.ext.unit.impl.TestCaseReportImpl;
import io.vertx.ext.unit.report.TestCaseReport;
import io.vertx.ext.unit.report.TestResult;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class TestCaseImpl
implements TestCase {
    final String name;
    final Handler<TestContext> handler;

    public TestCaseImpl(String name, Handler<TestContext> handler) {
        this.name = name;
        this.handler = handler;
    }

    private TestCaseReport runner() {
        return new TestCaseReportImpl(this.name, 0L, new HashMap<String, Object>(), null, this.handler, null, null);
    }

    public String name() {
        return this.name;
    }

    @Override
    public void awaitSuccess() {
        this.awaitSuccess(2L, TimeUnit.MINUTES);
    }

    @Override
    public void awaitSuccess(long timeout, TimeUnit unit) {
        this.awaitSuccess(new ExecutionContext(Vertx.currentContext()), timeout, unit);
    }

    @Override
    public void awaitSuccess(Vertx vertx, long timeout, TimeUnit unit) {
        this.awaitSuccess(new ExecutionContext(vertx.getOrCreateContext()), timeout, unit);
    }

    @Override
    public void awaitSuccess(Vertx vertx) {
        this.awaitSuccess(new ExecutionContext(vertx.getOrCreateContext()), 2L, TimeUnit.MINUTES);
    }

    private void awaitSuccess(ExecutionContext context, long timeout, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        TestCaseReportImpl testCase = (TestCaseReportImpl)this.runner();
        AtomicReference resultRef = new AtomicReference();
        testCase.endHandler((Handler<TestResult>)((Handler)result -> {
            resultRef.set(result);
            latch.countDown();
        }));
        Task<?> task = testCase.buildTask((v, executor) -> {});
        context.run(task);
        try {
            latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        TestResult result2 = (TestResult)resultRef.get();
        if (result2 == null) {
            throw new IllegalStateException("Time out");
        }
        if (result2.failed()) {
            Throwable failure = result2.failure().cause();
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
        }
    }
}

