/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.Handler;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.Result;
import io.vertx.ext.unit.impl.Task;
import io.vertx.ext.unit.impl.TestContextImpl;
import io.vertx.ext.unit.impl.TestResultImpl;
import io.vertx.ext.unit.report.TestCaseReport;
import io.vertx.ext.unit.report.TestResult;
import java.util.Map;
import java.util.function.Function;

public class TestCaseReportImpl
implements TestCaseReport {
    private final String name;
    private final long timeout;
    private final Map<String, Object> attributes;
    private final Handler<TestContext> before;
    private final Handler<TestContext> test;
    private final Handler<TestContext> after;
    private final Handler<Throwable> unhandledFailureHandler;
    private volatile Handler<TestResult> completionHandler;

    public TestCaseReportImpl(String name, long timeout, Map<String, Object> attributes, Handler<TestContext> before, Handler<TestContext> test, Handler<TestContext> after, Handler<Throwable> unhandledFailureHandler) {
        this.attributes = attributes;
        this.timeout = timeout;
        this.name = name;
        this.before = before;
        this.test = test;
        this.after = after;
        this.unhandledFailureHandler = unhandledFailureHandler;
    }

    Task<?> buildTask(Task<?> nextTask) {
        TestContextImpl completeHandler = (result, context) -> {
            if (this.completionHandler != null) {
                this.completionHandler.handle((Object)new TestResultImpl(this.name, result.beginTime, result.duration(), result.failure));
            }
            nextTask.execute(null, context);
        };
        TestContextImpl afterHandler = this.after != null ? new TestContextImpl(this.attributes, this.after, this.unhandledFailureHandler, completeHandler, this.timeout) : completeHandler;
        TestContextImpl testHandler = new TestContextImpl(this.attributes, this.test, this.unhandledFailureHandler, afterHandler, this.timeout);
        if (this.before != null) {
            Function<Result, Task<Result>> tmp = result -> {
                if (result.failure != null) {
                    return completeHandler;
                }
                return testHandler;
            };
            return new TestContextImpl(this.attributes, this.before, this.unhandledFailureHandler, tmp, this.timeout);
        }
        return testHandler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TestCaseReport endHandler(Handler<TestResult> handler) {
        this.completionHandler = handler;
        return this;
    }
}

