/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.junit;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.ExecutionContext;
import io.vertx.ext.unit.impl.Helper;
import io.vertx.ext.unit.impl.Result;
import io.vertx.ext.unit.impl.Task;
import io.vertx.ext.unit.impl.TestContextImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class VertxUnitRunner
extends BlockJUnit4ClassRunner {
    private static final LinkedList<Context> contextStack = new LinkedList();
    private final TestClass testClass;
    private final Long timeout;
    private Map<String, Object> classAttributes = new HashMap<String, Object>();
    private Map<String, Object> testAttributes;

    public VertxUnitRunner(Class<?> klass) throws InitializationError {
        this(klass, null);
    }

    public VertxUnitRunner(Class<?> klass, Long timeout) throws InitializationError {
        super(klass);
        this.timeout = timeout;
        this.testClass = new TestClass(klass);
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        if (annotation == Test.class || annotation == Before.class || annotation == After.class || annotation == BeforeClass.class || annotation == AfterClass.class) {
            List fMethods = this.getTestClass().getAnnotatedMethods(annotation);
            for (FrameworkMethod fMethod : fMethods) {
                fMethod.validatePublicVoid(isStatic, errors);
                try {
                    this.validateTestMethod(fMethod);
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
        } else {
            super.validatePublicVoidNoArgMethods(annotation, isStatic, errors);
        }
    }

    protected void validateTestMethod(FrameworkMethod fMethod) throws Exception {
        Class<?>[] paramTypes = fMethod.getMethod().getParameterTypes();
        if (!(paramTypes.length == 0 || paramTypes.length == 1 && paramTypes[0].equals(TestContext.class))) {
            throw new Exception("Method " + fMethod.getName() + " should have no parameters or " + "the " + TestContext.class.getName() + " parameter");
        }
    }

    protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                VertxUnitRunner.this.invokeExplosively(VertxUnitRunner.this.testAttributes, method, test);
            }
        };
    }

    protected void invokeTestMethod(FrameworkMethod fMethod, Object test, TestContext context) throws InvocationTargetException, IllegalAccessException {
        Method method = fMethod.getMethod();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 0) {
            method.invoke(test, new Object[0]);
        } else {
            method.invoke(test, context);
        }
    }

    private void invokeExplosively(Map<String, Object> attributes, FrameworkMethod fMethod, Object test) throws Throwable {
        Result result2;
        CompletableFuture future = new CompletableFuture();
        Task<Result> task = (result, context) -> future.complete(result);
        Handler callback = context -> {
            try {
                this.invokeTestMethod(fMethod, test, (TestContext)context);
            }
            catch (InvocationTargetException e) {
                Helper.uncheckedThrow(e.getCause());
            }
            catch (IllegalAccessException e) {
                Helper.uncheckedThrow(e);
            }
        };
        TestContextImpl context2 = new TestContextImpl(attributes, (Handler<TestContext>)callback, (Handler<Throwable>)((Handler)err -> {}), task, this.timeout != null ? this.timeout : 120000L);
        new ExecutionContext(contextStack.peek()).run(context2);
        try {
            result2 = (Result)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        Throwable failure = result2.getFailure();
        if (failure != null) {
            throw failure;
        }
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        this.testAttributes = new HashMap<String, Object>(this.classAttributes);
        return this.withBefores(this.testAttributes, this.getTestClass().getAnnotatedMethods(Before.class), target, statement);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return this.withAfters(this.testAttributes, afters, target, statement);
    }

    protected Statement withBeforeClasses(Statement statement) {
        List befores = this.testClass.getAnnotatedMethods(BeforeClass.class);
        return this.withBefores(this.classAttributes, befores, null, statement);
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        return this.withAfters(this.classAttributes, afters, null, statement);
    }

    private Statement withBefores(final Map<String, Object> attributes, final List<FrameworkMethod> befores, final Object target, final Statement statement) {
        if (befores.isEmpty()) {
            return statement;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                for (FrameworkMethod before : befores) {
                    VertxUnitRunner.this.invokeExplosively(attributes, before, target);
                }
                statement.evaluate();
            }
        };
    }

    private Statement withAfters(final Map<String, Object> attributes, final List<FrameworkMethod> afters, final Object target, final Statement statement) {
        if (afters.isEmpty()) {
            return statement;
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    statement.evaluate();
                }
                catch (Throwable e) {
                    errors.add(e);
                }
                finally {
                    for (FrameworkMethod after : afters) {
                        try {
                            VertxUnitRunner.this.invokeExplosively(attributes, after, target);
                        }
                        catch (Throwable e) {
                            errors.add(e);
                        }
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    static void pushContext(Context context) {
        contextStack.push(context);
    }

    static void popContext() {
        contextStack.pop();
    }
}

