/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.report;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.report.ReportOptions;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class ReportingOptions {
    private List<ReportOptions> reporters = new ArrayList<ReportOptions>();

    public ReportingOptions() {
    }

    public ReportingOptions(ReportingOptions other) {
        other.reporters.stream().map(ReportOptions::new).forEach(this.reporters::add);
    }

    public ReportingOptions(JsonObject json) {
        JsonArray reportersJson = json.getJsonArray("reporters");
        if (reportersJson != null) {
            for (int i = 0; i < reportersJson.size(); ++i) {
                JsonObject reportJson = reportersJson.getJsonObject(i);
                this.reporters.add(new ReportOptions(reportJson));
            }
        }
    }

    public List<ReportOptions> getReporters() {
        return this.reporters;
    }

    @Fluent
    public ReportingOptions addReporter(ReportOptions reportOptions) {
        this.reporters.add(reportOptions);
        return this;
    }

    @Fluent
    public ReportingOptions setReporters(List<ReportOptions> reporters) {
        this.reporters = reporters;
        return this;
    }

    public JsonObject toJson() {
        JsonObject config = new JsonObject();
        if (this.reporters.size() > 0) {
            JsonArray reportersJson = new JsonArray();
            this.reporters.stream().map(ReportOptions::toJson).forEach(arg_0 -> ((JsonArray)reportersJson).add(arg_0));
            config.put("reporters", reportersJson);
        }
        return config;
    }
}

