/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.impl.launcher.commands.RunCommand;
import io.vertx.ext.unit.impl.TestCaseImpl;
import io.vertx.ext.unit.impl.TestCompletionImpl;
import io.vertx.ext.unit.impl.TestSuiteImpl;
import io.vertx.ext.unit.impl.TestSuiteRunner;
import io.vertx.ext.unit.report.ReportOptions;
import io.vertx.ext.unit.report.impl.DefaultReporterFactory;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

@Name(value="test")
@Summary(value="Runs a Vert.x Unit test called <test-verticle> in its own instance of vert.x.")
@Description(value="Execute Vert.x Unit tests in its own instance of Vert.x. The Verticle must run a Vert.x Unit test suite, for instance:\n\n  var TestSuite = require('vertx-unit-js/test_suite');\n  var suite = TestSuite.create('my-suite');\n  ...\n  suite.run()\n\n> vertx test suite.js\n\nThe test command blocks until the suite is fully executed and then exit the JVM with the appropriate code: 0 for success, 1 for failure.\n\nThe test suite execution is also logged directly on the console.\n")
public class TestCommand
extends RunCommand {
    private final CompletableFuture<String> deployedFuture = new CompletableFuture();
    private String test;
    private boolean report;
    private long timeout;

    @Option(longName="test", argName="test")
    @Description(value="Select one or several tests to run")
    public void setTest(String test) {
        this.test = test;
    }

    @Option(longName="report", argName="report")
    @Description(value="Report the execution to a file in JUnit XML format")
    public void setReport(boolean report) {
        this.report = report;
    }

    @Option(longName="timeout", argName="timeout")
    @Description(value="Set the test suite timeout in millis")
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void deploy() {
        TestCompletionImpl completion;
        ConcurrentLinkedDeque completions = new ConcurrentLinkedDeque();
        TestSuiteImpl.setDefaultRunner((Handler<TestSuiteRunner>)((Handler)runner -> {
            if (this.test != null) {
                int pos;
                StringBuilder sb = new StringBuilder();
                int prev = 0;
                while ((pos = this.test.indexOf(42, prev)) != -1) {
                    sb.append(Pattern.quote(this.test.substring(prev, pos)));
                    sb.append(".*");
                    prev = pos + 1;
                }
                sb.append(Pattern.quote(this.test.substring(prev)));
                Pattern p = Pattern.compile(sb.toString());
                Iterator<TestCaseImpl> i = runner.getTests().iterator();
                while (i.hasNext()) {
                    TestCaseImpl test = i.next();
                    if (p.matcher(test.name).matches()) continue;
                    i.remove();
                }
            }
            TestCompletionImpl reporter = (TestCompletionImpl)runner.getReporter();
            DefaultReporterFactory f = new DefaultReporterFactory();
            reporter.addReporter(f.reporter(this.vertx, new ReportOptions().setTo("console")));
            if (this.report) {
                reporter.addReporter(f.reporter(this.vertx, new ReportOptions().setTo("file:.").setFormat("junit")));
            }
            if (this.timeout > 0L) {
                runner.setTimeout(this.timeout);
            }
            completions.add(reporter);
            runner.run();
        }));
        super.deploy();
        try {
            this.deployedFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.exit(1);
            return;
        }
        catch (ExecutionException e) {
            e.getCause().printStackTrace();
            System.exit(1);
            return;
        }
        while ((completion = (TestCompletionImpl)completions.poll()) != null) {
            completion.await();
        }
        System.exit(0);
    }

    public synchronized void deploy(String verticle, Vertx vertx, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        super.deploy(verticle, vertx, options, ar -> {
            if (ar.succeeded()) {
                this.deployedFuture.complete((String)ar.result());
            } else {
                this.deployedFuture.completeExceptionally(ar.cause());
            }
            if (completionHandler != null) {
                completionHandler.handle(ar);
            }
        });
    }
}

