/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.CompletionImpl;
import io.vertx.ext.unit.impl.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class TestContextImpl
implements TestContext {
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private final Map<String, Object> attributes;
    private final Handler<Throwable> unhandledFailureHandler;
    private Step current;

    public TestContextImpl(Map<String, Object> attributes, Handler<Throwable> unhandledFailureHandler) {
        this.attributes = attributes;
        this.unhandledFailureHandler = unhandledFailureHandler;
    }

    @Override
    public synchronized <T> T get(String key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public synchronized <T> T put(String key, Object value) {
        if (value != null) {
            return (T)this.attributes.put(key, value);
        }
        return (T)this.attributes.remove(key);
    }

    @Override
    public synchronized <T> T remove(String key) {
        return (T)this.attributes.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Throwable failed, long timeout, Handler<TestContext> test, Handler<Throwable> endHandler) {
        Step step;
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.current != null) {
                throw new IllegalStateException("Wrong status");
            }
            this.current = step = new Step(endHandler, failed);
        }
        step.run(timeout, (Handler<TestContext>)test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable t) {
        boolean reported;
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            reported = this.current != null && this.current.failed(t);
        }
        if (!reported && this.unhandledFailureHandler != null) {
            this.unhandledFailureHandler.handle((Object)t);
        }
    }

    @Override
    public Async async() {
        return this.async(1);
    }

    @Override
    public Async async(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Async completion count must be > 0");
        }
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.current != null) {
                return this.current.async(count);
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public TestContext assertNull(Object expected) {
        return this.assertNull(expected, null);
    }

    @Override
    public TestContext assertNull(Object expected, String message) {
        if (expected != null) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null"));
        }
        return this;
    }

    @Override
    public TestContext assertNotNull(Object expected) {
        return this.assertNotNull(expected, null);
    }

    @Override
    public TestContext assertNotNull(Object expected, String message) {
        if (expected == null) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected not null"));
        }
        return this;
    }

    @Override
    public TestContext assertTrue(boolean condition, String message) {
        if (!condition) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected true"));
        }
        return this;
    }

    @Override
    public TestContext assertTrue(boolean condition) {
        return this.assertTrue(condition, null);
    }

    @Override
    public TestContext assertFalse(boolean condition) {
        return this.assertFalse(condition, null);
    }

    @Override
    public TestContext assertFalse(boolean condition, String message) {
        if (condition) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected false"));
        }
        return this;
    }

    @Override
    public void fail() {
        this.fail((String)null);
    }

    @Override
    public void fail(String message) {
        throw this.reportAssertionError(message != null ? message : "Test failed");
    }

    @Override
    public void fail(Throwable cause) {
        this.failed(cause);
        Helper.uncheckedThrow(cause);
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this::failed;
    }

    @Override
    public TestContext assertEquals(Object expected, Object actual) {
        return this.assertEquals(expected, actual, null);
    }

    @Override
    public TestContext assertEquals(Object expected, Object actual, String message) {
        if (actual == null) {
            if (expected != null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected " + expected + " got null"));
            }
        } else {
            if (expected == null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null instead of " + actual));
            }
            if (!expected.equals(actual)) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Not equals : " + expected + " != " + actual));
            }
        }
        return this;
    }

    @Override
    public TestContext assertInRange(double expected, double actual, double delta) {
        return this.assertInRange(expected, actual, delta, null);
    }

    @Override
    public TestContext assertInRange(double expected, double actual, double delta, String message) {
        if (Double.compare(expected, actual) != 0 && Math.abs(actual - expected) > delta) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected " + actual + " to belong to [" + (expected - delta) + "," + (expected + delta) + "]"));
        }
        return this;
    }

    @Override
    public TestContext assertNotEquals(Object first, Object second, String message) {
        if (first == null) {
            if (second == null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null != null"));
            }
        } else if (first.equals(second)) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected different values " + first + " != " + second));
        }
        return this;
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertSuccess() {
        return this.asyncAssertSuccess(result -> {});
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertSuccess(Handler<T> resultHandler) {
        Async async = this.async();
        return ar -> {
            if (ar.succeeded()) {
                Object result = ar.result();
                try {
                    resultHandler.handle(result);
                    async.complete();
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            } else {
                this.failed(ar.cause());
            }
        };
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertFailure() {
        return this.asyncAssertFailure((Handler<Throwable>)((Handler)cause -> {}));
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertFailure(Handler<Throwable> causeHandler) {
        Async async = this.async();
        return ar -> {
            if (ar.failed()) {
                Throwable result = ar.cause();
                try {
                    causeHandler.handle((Object)result);
                    async.complete();
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            } else {
                this.reportAssertionError("Was expecting a failure instead of of success");
            }
        };
    }

    @Override
    public TestContext assertNotEquals(Object first, Object second) {
        return this.assertNotEquals(first, second, null);
    }

    private AssertionError reportAssertionError(String message) {
        AssertionError err = new AssertionError((Object)message);
        this.failed((Throwable)((Object)err));
        return err;
    }

    private static String formatMessage(String providedMessage, String defaultMessage) {
        return providedMessage == null ? defaultMessage : providedMessage + ". " + defaultMessage;
    }

    private class Step {
        private final Handler<Throwable> endHandler;
        private final LinkedList<AsyncImpl> asyncs = new LinkedList();
        private boolean running = true;
        private boolean complete;
        private Throwable failure;

        public Step(Handler<Throwable> endHandler, Throwable failure) {
            this.endHandler = endHandler;
            this.failure = failure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryEnd() {
            List<AsyncImpl> copy;
            boolean end = false;
            Step step = this;
            synchronized (step) {
                if (!(!this.asyncs.isEmpty() && this.failure == null || this.complete || this.running)) {
                    this.complete = true;
                    end = true;
                }
                if (end) {
                    copy = new ArrayList<AsyncImpl>(this.asyncs);
                    this.asyncs.clear();
                    TestContextImpl testContextImpl = TestContextImpl.this;
                    synchronized (testContextImpl) {
                        TestContextImpl.this.current = null;
                    }
                    this.notify();
                } else {
                    copy = Collections.emptyList();
                }
            }
            if (end) {
                for (AsyncImpl a : copy) {
                    a.release();
                }
                this.endHandler.handle((Object)this.failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean failed(Throwable t) {
            Step step = this;
            synchronized (step) {
                if (this.complete) {
                    return false;
                }
                if (this.failure == null) {
                    this.failure = t;
                }
            }
            this.tryEnd();
            return true;
        }

        private AsyncImpl async(int count) {
            Step step = this;
            synchronized (step) {
                if (!this.complete) {
                    AsyncImpl async = new AsyncImpl(count);
                    if (this.failure == null) {
                        this.asyncs.add(async);
                    }
                    return async;
                }
                throw new IllegalStateException("Test already completed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run(long timeout, Handler<TestContext> test) {
            Object cancel;
            if (timeout > 0L) {
                cancel = () -> {
                    try {
                        Step step = this;
                        synchronized (step) {
                            if (this.complete) {
                                return;
                            }
                            this.wait(timeout);
                            if (this.complete) {
                                return;
                            }
                            this.running = false;
                        }
                        this.failed(new TimeoutException());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                };
                Thread timeoutThread = new Thread((Runnable)cancel);
                timeoutThread.setName("vert.x-unit-timeout-thread-" + threadCount.incrementAndGet());
                timeoutThread.start();
            }
            try {
                test.handle((Object)TestContextImpl.this);
            }
            catch (Throwable t) {
                this.failed(t);
            }
            finally {
                cancel = this;
                synchronized (cancel) {
                    this.running = false;
                }
                this.tryEnd();
            }
        }

        class AsyncImpl
        extends CompletionImpl<Void>
        implements Async {
            private final int initialCount;
            private final AtomicInteger current;

            public AsyncImpl(int initialCount) {
                this.initialCount = initialCount;
                this.current = new AtomicInteger(initialCount);
            }

            @Override
            public int count() {
                return this.current.get();
            }

            @Override
            public void countDown() {
                int value = this.current.updateAndGet(v -> v > 0 ? v - 1 : 0);
                if (value == 0) {
                    this.completable.complete(null);
                    this.internalComplete();
                }
            }

            @Override
            public void complete() {
                int value = this.current.getAndSet(0);
                if (value > 0) {
                    this.completable.complete(null);
                    this.internalComplete();
                } else if (value < 0) {
                    throw new IllegalStateException("The Async complete method has been called more than " + this.initialCount + " times, check your test.");
                }
            }

            private void release() {
                if (Step.this.failure != null) {
                    this.completable.completeExceptionally(Step.this.failure);
                } else {
                    this.completable.complete(null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void internalComplete() {
                boolean complete;
                Step step = Step.this;
                synchronized (step) {
                    complete = Step.this.asyncs.remove(this);
                }
                if (complete) {
                    Step.this.tryEnd();
                }
                this.release();
            }
        }
    }
}

