/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.Handler;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.ExecutionContext;
import io.vertx.ext.unit.impl.Result;
import io.vertx.ext.unit.impl.Task;
import io.vertx.ext.unit.impl.TestContextImpl;
import java.util.function.Function;

public class TestContextTask
implements Task<Result> {
    private final TestContextImpl testContext;
    private final Handler<TestContext> callback;
    private Function<Result, Task<Result>> next;
    private final long timeout;

    public TestContextTask(TestContextImpl testContext, Handler<TestContext> callback, Task<Result> next, long timeout) {
        this.testContext = testContext;
        this.callback = callback;
        this.next = result -> next;
        this.timeout = timeout;
    }

    public TestContextTask(TestContextImpl testContext, Handler<TestContext> callback, Function<Result, Task<Result>> next, long timeout) {
        this.testContext = testContext;
        this.callback = callback;
        this.next = next;
        this.timeout = timeout;
    }

    @Override
    public void execute(Result prev, ExecutionContext context) {
        long beginTime = prev != null ? prev.beginTime : System.currentTimeMillis();
        this.testContext.run(prev != null ? prev.failure : null, this.timeout, this.callback, (Handler<Throwable>)((Handler)failed -> {
            long endTime = System.currentTimeMillis();
            Result result = new Result(beginTime, endTime, (Throwable)failed);
            context.run(this.next.apply(result), result);
        }));
    }
}

