/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.unit;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rxjava.core.Future;

/**
 * An asynchronous exit point for a test.<p/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.Async original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.unit.Async.class)
public class Async extends Completion<Void> {

  public static final io.vertx.lang.rxjava.TypeArg<Async> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new Async((io.vertx.ext.unit.Async) obj),
    Async::getDelegate
  );

  private final io.vertx.ext.unit.Async delegate;
  
  public Async(io.vertx.ext.unit.Async delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.unit.Async getDelegate() {
    return delegate;
  }

  /**
   * Completes the future upon completion, otherwise fails it.
   * @param future the future to resolve
   */
  public void resolve(Future<Void> future) { 
    delegate.resolve(future.getDelegate());
  }

  /**
   * Completion handler to receive a completion signal when this completions completes.
   * @param completionHandler the completion handler
   */
  public void handler(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.handler(completionHandler);
  }

  /**
   * Completion handler to receive a completion signal when this completions completes.
   * @return 
   * @deprecated use {@link #rxHandler} instead
   */
  @Deprecated()
  public Observable<Void> handlerObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    handler(completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Completion handler to receive a completion signal when this completions completes.
   * @return 
   */
  public Single<Void> rxHandler() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      handler(fut);
    }));
  }

  /**
   * @return the current count
   */
  public int count() { 
    int ret = delegate.count();
    return ret;
  }

  /**
   * Count down the async.
   */
  public void countDown() { 
    delegate.countDown();
  }

  /**
   * Signals the asynchronous operation is done, this method must be called with a count greater than <code>0</code>,
   * otherwise it throws an <code>IllegalStateException</code> to signal the error.
   */
  public void complete() { 
    delegate.complete();
  }


  public static Async newInstance(io.vertx.ext.unit.Async arg) {
    return arg != null ? new Async(arg) : null;
  }
}
