/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.junit;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RunTestOnContext
implements TestRule {
    private volatile Vertx vertx;
    private final Supplier<Vertx> createVertx;
    private final BiConsumer<Vertx, CountDownLatch> closeVertx;

    public RunTestOnContext() {
        this(new VertxOptions());
    }

    public RunTestOnContext(VertxOptions options) {
        this(() -> Vertx.vertx((VertxOptions)options));
    }

    public RunTestOnContext(Supplier<Vertx> createVertx, BiConsumer<Vertx, Consumer<Void>> closeVertx) {
        this.createVertx = createVertx;
        this.closeVertx = (vertx, latch) -> closeVertx.accept((Vertx)vertx, v -> latch.countDown());
    }

    public RunTestOnContext(Supplier<Vertx> createVertx) {
        this(createVertx, (vertx, latch) -> vertx.close(ar -> latch.accept(null)));
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RunTestOnContext.this.vertx = (Vertx)RunTestOnContext.this.createVertx.get();
                try {
                    Context context = RunTestOnContext.this.vertx != null ? RunTestOnContext.this.vertx.getOrCreateContext() : null;
                    VertxUnitRunner.pushContext(context);
                    base.evaluate();
                }
                finally {
                    VertxUnitRunner.popContext();
                    CountDownLatch latch = new CountDownLatch(1);
                    RunTestOnContext.this.closeVertx.accept(RunTestOnContext.this.vertx, latch);
                    try {
                        if (!latch.await(30000L, TimeUnit.MILLISECONDS)) {
                            Logger logger = LoggerFactory.getLogger((Class)description.getTestClass());
                            logger.warn((Object)"Could not close Vert.x in tme");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }
}

