/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.report.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.impl.FailureImpl;
import io.vertx.ext.unit.report.Failure;
import io.vertx.ext.unit.report.Reporter;
import io.vertx.ext.unit.report.TestResult;

public class EventBusReporter
implements Reporter<EventBusReport> {
    private final Vertx vertx;
    private final String address;

    public EventBusReporter(Vertx vertx, String address) {
        this.vertx = vertx;
        this.address = address;
    }

    @Override
    public EventBusReport reportBeginTestSuite(String name) {
        EventBusReport report = new EventBusReport(name);
        this.vertx.eventBus().publish(this.address, (Object)new JsonObject().put("type", (Object)"testSuiteBegin").put("name", (Object)name));
        return report;
    }

    @Override
    public void reportBeginTestCase(EventBusReport report, String name) {
        this.vertx.eventBus().publish(this.address, (Object)new JsonObject().put("type", (Object)"testCaseBegin").put("name", (Object)name));
    }

    @Override
    public void reportEndTestCase(EventBusReport report, String name, TestResult result) {
        JsonObject json = new JsonObject().put("type", (Object)"testCaseEnd").put("name", (Object)result.name()).put("beginTime", (Object)result.beginTime()).put("durationTime", (Object)result.durationTime());
        if (result.failed()) {
            Failure failure = result.failure();
            json.put("failure", (Object)((FailureImpl)failure).toJson());
        }
        this.vertx.eventBus().publish(this.address, (Object)json);
    }

    @Override
    public void reportError(EventBusReport report, Throwable err) {
        JsonObject msg = new JsonObject().put("type", (Object)"testSuiteError");
        msg.put("failure", (Object)new FailureImpl(err).toJson());
        this.vertx.eventBus().publish(this.address, (Object)msg);
    }

    @Override
    public void reportEndTestSuite(EventBusReport report) {
        JsonObject msg = new JsonObject().put("type", (Object)"testSuiteEnd").put("name", (Object)report.name);
        this.vertx.eventBus().publish(this.address, (Object)msg);
    }

    public static class EventBusReport {
        final String name;

        public EventBusReport(String name) {
            this.name = name;
        }
    }
}

