/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.AsyncImpl;
import io.vertx.ext.unit.impl.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class TestContextImpl
implements TestContext {
    private static final AtomicInteger threadCount = new AtomicInteger(0);
    private static final Throwable SUCCESS = new Throwable();
    private final Map<String, Object> attributes;
    private final Handler<Throwable> unhandledFailureHandler;
    private CountDownLatch completionLatch;
    private Handler<Throwable> completionHandler;
    private List<AsyncImpl> asyncs = new ArrayList<AsyncImpl>();
    private Throwable completionResult;
    private boolean running;

    public TestContextImpl(Map<String, Object> attributes, Handler<Throwable> unhandledFailureHandler) {
        this.attributes = attributes;
        this.unhandledFailureHandler = unhandledFailureHandler;
    }

    @Override
    public synchronized <T> T get(String key) {
        return (T)this.attributes.get(key);
    }

    @Override
    public synchronized <T> T put(String key, Object value) {
        if (value != null) {
            return (T)this.attributes.put(key, value);
        }
        return (T)this.attributes.remove(key);
    }

    @Override
    public synchronized <T> T remove(String key) {
        return (T)this.attributes.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Throwable failed, long timeout, Handler<TestContext> test, Handler<Throwable> eh) {
        CountDownLatch latch = new CountDownLatch(1);
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.running) {
                throw new IllegalStateException("Already running");
            }
            this.running = true;
            this.completionLatch = latch;
            this.completionResult = null;
            this.completionHandler = err -> {
                if (failed != null) {
                    eh.handle((Object)failed);
                } else {
                    eh.handle(err);
                }
            };
        }
        if (timeout > 0L) {
            Runnable cancel = () -> {
                try {
                    if (latch.await(timeout, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                    this.tryFail(new TimeoutException());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            };
            Thread timeoutThread = new Thread(cancel);
            timeoutThread.setName("vert.x-unit-timeout-thread-" + threadCount.incrementAndGet());
            timeoutThread.start();
        }
        Async async = this.async(1, false);
        try {
            test.handle((Object)this);
            async.complete();
        }
        catch (Throwable t) {
            this.tryFail(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable t) {
        boolean reported;
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            reported = this.running && this.tryFail(t);
        }
        if (!reported && this.unhandledFailureHandler != null) {
            this.unhandledFailureHandler.handle((Object)t);
        }
    }

    private boolean tryFail(Throwable t) {
        return this.tryEnd(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryEnd(Throwable cause) {
        Handler<Throwable> handler;
        ArrayList<AsyncImpl> copy;
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.completionResult != null || this.asyncs.size() > 0 && cause == null) {
                return false;
            }
            this.completionResult = cause == null ? SUCCESS : cause;
            copy = new ArrayList<AsyncImpl>(this.asyncs);
            this.asyncs.clear();
            this.running = false;
            handler = this.completionHandler;
            this.completionLatch.countDown();
        }
        for (AsyncImpl a : copy) {
            a.release(cause);
        }
        handler.handle((Object)cause);
        return true;
    }

    @Override
    public Async async() {
        return this.async(1);
    }

    @Override
    public Async async(int count) {
        return this.async(count, false);
    }

    @Override
    public Async strictAsync(int count) {
        return this.async(count, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Async async(int count, boolean strict) {
        if (count < 1) {
            throw new IllegalArgumentException("Async completion count must be > 0");
        }
        TestContextImpl testContextImpl = this;
        synchronized (testContextImpl) {
            if (this.running) {
                if (this.completionResult == null) {
                    AsyncImpl async = new AsyncImpl(count, strict);
                    this.asyncs.add(async);
                    async.completable.whenComplete((v, err) -> {
                        TestContextImpl testContextImpl = this;
                        synchronized (testContextImpl) {
                            this.asyncs.remove(async);
                        }
                        this.tryEnd(null);
                    });
                    return async;
                }
                throw new IllegalStateException("Test already completed");
            }
            return new AsyncImpl(count, strict);
        }
    }

    @Override
    public TestContext assertNull(Object expected) {
        return this.assertNull(expected, null);
    }

    @Override
    public TestContext assertNull(Object expected, String message) {
        if (expected != null) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null"));
        }
        return this;
    }

    @Override
    public TestContext assertNotNull(Object expected) {
        return this.assertNotNull(expected, null);
    }

    @Override
    public TestContext assertNotNull(Object expected, String message) {
        if (expected == null) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected not null"));
        }
        return this;
    }

    @Override
    public TestContext assertTrue(boolean condition, String message) {
        if (!condition) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected true"));
        }
        return this;
    }

    @Override
    public TestContext assertTrue(boolean condition) {
        return this.assertTrue(condition, null);
    }

    @Override
    public TestContext assertFalse(boolean condition) {
        return this.assertFalse(condition, null);
    }

    @Override
    public TestContext assertFalse(boolean condition, String message) {
        if (condition) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected false"));
        }
        return this;
    }

    @Override
    public void fail() {
        this.fail((String)null);
    }

    @Override
    public void fail(String message) {
        throw this.reportAssertionError(message != null ? message : "Test failed");
    }

    @Override
    public void fail(Throwable cause) {
        this.failed(cause);
        Helper.uncheckedThrow(cause);
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this::failed;
    }

    @Override
    public TestContext assertEquals(Object expected, Object actual) {
        return this.assertEquals(expected, actual, null);
    }

    @Override
    public TestContext assertEquals(Object expected, Object actual, String message) {
        if (actual == null) {
            if (expected != null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected " + expected + " got null"));
            }
        } else {
            if (expected == null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null instead of " + actual));
            }
            if (!expected.equals(actual)) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Not equals : " + expected + " != " + actual));
            }
        }
        return this;
    }

    @Override
    public TestContext assertInRange(double expected, double actual, double delta) {
        return this.assertInRange(expected, actual, delta, null);
    }

    @Override
    public TestContext assertInRange(double expected, double actual, double delta, String message) {
        if (Double.compare(expected, actual) != 0 && Math.abs(actual - expected) > delta) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected " + actual + " to belong to [" + (expected - delta) + "," + (expected + delta) + "]"));
        }
        return this;
    }

    @Override
    public TestContext assertNotEquals(Object first, Object second, String message) {
        if (first == null) {
            if (second == null) {
                throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected null != null"));
            }
        } else if (first.equals(second)) {
            throw this.reportAssertionError(TestContextImpl.formatMessage(message, "Expected different values " + first + " != " + second));
        }
        return this;
    }

    @Override
    public TestContext verify(Handler<Void> block) {
        try {
            block.handle(null);
        }
        catch (Throwable t) {
            this.fail(t);
        }
        return this;
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertSuccess() {
        return this.asyncAssertSuccess(result -> {});
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertSuccess(Handler<T> resultHandler) {
        Async async = this.async();
        return ar -> {
            if (ar.succeeded()) {
                Object result = ar.result();
                try {
                    resultHandler.handle(result);
                    async.complete();
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            } else {
                this.failed(ar.cause());
            }
        };
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertFailure() {
        return this.asyncAssertFailure((Handler<Throwable>)((Handler)cause -> {}));
    }

    @Override
    public <T> Handler<AsyncResult<T>> asyncAssertFailure(Handler<Throwable> causeHandler) {
        Async async = this.async();
        return ar -> {
            if (ar.failed()) {
                Throwable result = ar.cause();
                try {
                    causeHandler.handle((Object)result);
                    async.complete();
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            } else {
                this.reportAssertionError("Was expecting a failure instead of of success");
            }
        };
    }

    @Override
    public TestContext assertNotEquals(Object first, Object second) {
        return this.assertNotEquals(first, second, null);
    }

    private AssertionError reportAssertionError(String message) {
        AssertionError err = new AssertionError((Object)message);
        this.failed((Throwable)((Object)err));
        return err;
    }

    private static String formatMessage(String providedMessage, String defaultMessage) {
        return providedMessage == null ? defaultMessage : providedMessage + ". " + defaultMessage;
    }
}

